-- Split Brakes - V1.1.0.0 - 11.12.2025
-- This mod and all its contents are the property of ChristophK.
-- Reuploading, modifying, or redistributing without permission is prohibited.

SplitBrakes = {}
SplitBrakes.MOD_NAME = g_currentModName

-- Multiplikator Bremsmoment bei angezogener Einzelradbremse:
SplitBrakes.BrakeForceMultiplikator = 40

-- Reibkoeffizient Vorderräder: 1 = Keine Skalierung, 0 = Keine Reibung
SplitBrakes.frictionFrontMultiplikatorLow = 0.3
SplitBrakes.frictionFrontMultiplikatorHigh = 1.2

-- Reibkoeffizient Hinterräder
SplitBrakes.frictionRearMultiplikator = 15

-- Drehmoment und Drehzahl des Motors skalieren: 1= Keine Skalierung
SplitBrakes.TorqueScaleMotor = 2
SplitBrakes.RotationSpeedsScaleMotor = 1

-- Drehmomentverhältnis zwischen gebremsten und ungebremsten Hinterrad: Für < 1 Keine vollständige Sperrung
SplitBrakes.TorqueRatioModded = 1

-- Geschwindigkeitsverhältnis zwischen gebremsten und ungebremsten Hinterrad
SplitBrakes.MaxSpeedRatioFaktor = 1000


-- Netzwerksynchronisation
SplitBrakesSyncEvent = {}
SplitBrakesSyncEvent_mt = Class(SplitBrakesSyncEvent, Event)

InitEventClass(SplitBrakesSyncEvent, "SplitBrakesSyncEvent")

function SplitBrakesSyncEvent.emptyNew()
    local self = Event.new(SplitBrakesSyncEvent_mt)
    return self
end

function SplitBrakesSyncEvent.new(vehicle, leftBrake, rightBrake)
    local self = SplitBrakesSyncEvent.emptyNew()
    self.vehicle = vehicle
    self.leftBrake = leftBrake
    self.rightBrake = rightBrake
    return self
end

function SplitBrakesSyncEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self.leftBrake = streamReadBool(streamId)
    self.rightBrake = streamReadBool(streamId)
    self:run(connection)
end

function SplitBrakesSyncEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    streamWriteBool(streamId, self.leftBrake)
    streamWriteBool(streamId, self.rightBrake)
end

function SplitBrakesSyncEvent:run(connection)
    if self.vehicle ~= nil then
        if connection:getIsServer() then
            self.vehicle.brakeLeftActive = self.leftBrake
            self.vehicle.brakeRightActive = self.rightBrake
        else
            self.vehicle.brakeLeftActive = self.leftBrake
            self.vehicle.brakeRightActive = self.rightBrake
            g_server:broadcastEvent(SplitBrakesSyncEvent.new(self.vehicle, self.leftBrake, self.rightBrake), nil, connection, self.vehicle)
        end
    end
end

function SplitBrakes.prerequisitesPresent()
    return true
end

function SplitBrakes.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad",                 SplitBrakes)
    SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", SplitBrakes)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdate",               SplitBrakes)
    SpecializationUtil.registerEventListener(vehicleType, "onPostLoad",             SplitBrakes)
    SpecializationUtil.registerEventListener(vehicleType, "onWriteStream",          SplitBrakes)
    SpecializationUtil.registerEventListener(vehicleType, "onReadStream",           SplitBrakes)
end

function SplitBrakes:onLoad(savegame)
    self.brakeLeftActive  = false
    self.brakeRightActive = false
	self.enableSafeVdata = true
    self.spec_splitBrakes = {actionEvents = {}, actionEventIds = {}}
    self.spec_splitBrakes.dirtyFlag = self:getNextDirtyFlag()
end

function SplitBrakes:onWriteStream(streamId, connection)
    streamWriteBool(streamId, self.brakeLeftActive)
    streamWriteBool(streamId, self.brakeRightActive)
end

function SplitBrakes:onReadStream(streamId, connection)
    self.brakeLeftActive = streamReadBool(streamId)
    self.brakeRightActive = streamReadBool(streamId)
end

function SplitBrakes:onPostLoad(savegame)
    if not (self.spec_wheels and self.spec_wheels.wheels) then
        return
    end
	
	--Falls Truck, Splitbrakes deaktivieren:
	--DebugUtil.printTableRecursively(self, ".", 0, 2)
	--print("SplitBrakes: " .. self.vehicleLoadingData.storeItem.categoryName)
	categoryName=self.vehicleLoadingData.storeItem.categoryName
	if categoryName=="TRUCKS" or categoryName=="TELELOADERVEHICLES" or categoryName=="WHEELLOADERVEHICLES" or categoryName=="FRONTLOADERVEHICLES" or categoryName=="COMBINEWINDROWER" then
		self.setSplitBrakesInactive = true
		return
	end
	
	self.brakeActiveTemp = 0
	self.wheelRpmLeft = 0
	self.wheelRpmRight = 0
	self.smoothBrakeLeft = 0
	self.smoothBrakeRight = 0
    self.spec_splitBrakes.leftRear, self.spec_splitBrakes.rightRear = {}, {}
    self.spec_splitBrakes.leftFront, self.spec_splitBrakes.rightFront = {}, {}

	local wheels = self:getWheels()

	--print("[SWB] Anzahl der Räder: " .. #wheels)
	if #wheels == 4 then		--Normales 4WD oder 2WD; Raupenfahrzeuge mit 4 "Rädern" ausschließen, da diese im Spiel nicht kontinuierlich implementiert sind
		if self.spec_wheels.wheels[1].physics.tireType == 4 then
			self.setSplitBrakesInactive = true
			return
		end
		
		self.spec_splitBrakes.leftFront[1] = 	wheels[1]
		self.spec_splitBrakes.rightFront[1] = 	wheels[2]
		self.spec_splitBrakes.leftRear[1] = 	wheels[3]
		self.spec_splitBrakes.rightRear[1] = 	wheels[4]
	elseif #wheels == 6 then	-- Hinten Ketten
		if self.spec_crawlers ~= nil and self.spec_crawlers.crawlers ~= nil then
			local i=1
			while i<=5 do
				if self.spec_wheels.wheels[i].physics.tireType == 1 then
					self.spec_splitBrakes.leftFront[1] = 	wheels[self.spec_wheels.wheels[i].wheelIndex]
					self.spec_splitBrakes.leftFront[1].physics.wheelIndex=self.spec_wheels.wheels[i].wheelIndex
					self.spec_splitBrakes.rightFront[1] = 	wheels[self.spec_wheels.wheels[i+1].wheelIndex]
					self.spec_splitBrakes.rightFront[1].physics.wheelIndex=self.spec_wheels.wheels[i+1].wheelIndex
				elseif self.spec_wheels.wheels[i].physics.tireType == 4 then
					if #self.spec_splitBrakes.leftRear < 2 then
						table.insert(self.spec_splitBrakes.leftRear, wheels[self.spec_wheels.wheels[i].wheelIndex])	
						table.insert(self.spec_splitBrakes.leftRear, wheels[self.spec_wheels.wheels[i+1].wheelIndex])	
						self.spec_splitBrakes.leftRear[1].physics.wheelIndex=self.spec_wheels.wheels[i].wheelIndex
						self.spec_splitBrakes.leftRear[2].physics.wheelIndex=self.spec_wheels.wheels[i+1].wheelIndex
					elseif #self.spec_splitBrakes.rightRear < 2 then
						table.insert(self.spec_splitBrakes.rightRear, wheels[self.spec_wheels.wheels[i].wheelIndex])	
						table.insert(self.spec_splitBrakes.rightRear, wheels[self.spec_wheels.wheels[i+1].wheelIndex])
						self.spec_splitBrakes.rightRear[1].physics.wheelIndex=self.spec_wheels.wheels[i].wheelIndex
						self.spec_splitBrakes.rightRear[2].physics.wheelIndex=self.spec_wheels.wheels[i+1].wheelIndex
					end
				end
				i=i+2
			end
		end
	elseif #wheels == 8 then	-- Überall Ketten
		self.setSplitBrakesInactive = true
		return
	end
	
	--print("[SWB] Rädercode: " .. #self.spec_splitBrakes.rightFront .. "; "  .. #self.spec_splitBrakes.leftFront .. "; "  .. #self.spec_splitBrakes.rightRear .. "; "  .. #self.spec_splitBrakes.leftRear)
		
	--tireType vorne und hinten sichern
	for _, z in ipairs(self.spec_splitBrakes.leftFront) do
		z.physics.originalTireType = z.physics.tireType
	end
	for _, z in ipairs(self.spec_splitBrakes.rightFront) do
		z.physics.originalTireType = z.physics.tireType
	end
	for _, z in ipairs(self.spec_splitBrakes.leftRear) do
		z.physics.originalTireType = z.physics.tireType
	end
	for _, z in ipairs(self.spec_splitBrakes.rightRear) do
		z.physics.originalTireType = z.physics.tireType
	end
	
	local frictionMultFrontHigh = SplitBrakes.frictionFrontMultiplikatorHigh
	local frictionMultFrontLow = SplitBrakes.frictionFrontMultiplikatorLow
	local frictionMultRear = SplitBrakes.frictionRearMultiplikator
	local originalTireTypeFront = WheelsUtil.tireTypes[self.spec_splitBrakes.rightFront[1].physics.originalTireType]
	local originalTireTypeRear = WheelsUtil.tireTypes[self.spec_splitBrakes.rightRear[1].physics.originalTireType]
	
	if WheelsUtil.getTireType("LOWGRIP_FRONT") == nil then
		local friction = {}
		local frictionWet = {}
		local frictionSnow = {}
		for i=1,4 do
			friction[i] = originalTireTypeFront.frictionCoeffs[i] * frictionMultFrontLow
			frictionWet[i] = originalTireTypeFront.frictionCoeffsWet[i] * frictionMultFrontLow
			frictionSnow[i] = originalTireTypeFront.frictionCoeffsSnow[i] * frictionMultFrontLow
		end
		WheelsUtil.registerTireType("LOWGRIP_FRONT", friction, frictionWet, frictionSnow)
	end
	
	if WheelsUtil.getTireType("HIGHGRIP_FRONT") == nil then
		local friction = {}
		local frictionWet = {}
		local frictionSnow = {}
		for i=1,4 do
			friction[i] = originalTireTypeFront.frictionCoeffs[i] * frictionMultFrontHigh
			frictionWet[i] = originalTireTypeFront.frictionCoeffsWet[i] * frictionMultFrontHigh
			frictionSnow[i] = originalTireTypeFront.frictionCoeffsSnow[i] * frictionMultFrontHigh
		end
		WheelsUtil.registerTireType("HIGHGRIP_FRONT", friction, frictionWet, frictionSnow)
	end
	
	if WheelsUtil.getTireType("HIGHGRIP_REAR") == nil then
		local friction = {}
		local frictionWet = {}
		local frictionSnow = {}
		for i=1,4 do
			friction[i] = originalTireTypeRear.frictionCoeffs[i] * frictionMultRear
			frictionWet[i] = originalTireTypeRear.frictionCoeffsWet[i] * frictionMultRear
			frictionSnow[i] = originalTireTypeRear.frictionCoeffsSnow[i] * frictionMultRear
		end
		WheelsUtil.registerTireType("HIGHGRIP_REAR", friction, frictionWet, frictionSnow)
	end
	
	-- Prüfen ob EnhancedVehicle installiert ist
	for name, spec in pairs(g_specializationManager:getSpecializations()) do
		if string.find(name, "EnhancedVehicle")~=nil then
			SplitBrakes.existEnhancedVehicle=true
			break
		end
	end
	
	-- Differentiale Standardwerte sichern
	if self.spec_motorized and self.spec_motorized.differentials then
		self.diff = {}
		self.diff.torqueRatio = {0.5, 0.5}
		self.diff.maxSpeedRatio = {1.0, 1.0}
		local numDiffs = #self.spec_motorized.differentials
		for _,d in ipairs(self.spec_motorized.differentials) do
			if d.diffIndex1 == 0 then     		-- Index 0 steht für Mitteldifferential
				self.diff.torqueRatio[2]   = d.torqueRatio
				self.diff.maxSpeedRatio[2] = d.maxSpeedRatio
			end
			if numDiffs == 1 or numDiffs == 3 then
				if d.diffIndex1 == 3 then      	-- Index 3 steht für Hinterachse bei normalen 2WD und 4WD
					self.diff.torqueRatio[1]   = d.torqueRatio
					self.diff.maxSpeedRatio[1] = d.maxSpeedRatio
				end
			elseif numDiffs == 5 then
				if d.diffIndex1 == 1 then      	-- Index 1 steht für Hinterachse bei Ketten hinten
					self.diff.torqueRatio[1]   = d.torqueRatio
					self.diff.maxSpeedRatio[1] = d.maxSpeedRatio
				end
			elseif numDiffs == 7 then
				if d.diffIndex1 == 5 then      	-- Index 5 steht für Hinterachse bei Ketten vorne und hinten
					self.diff.torqueRatio[1]   = d.torqueRatio
					self.diff.maxSpeedRatio[1] = d.maxSpeedRatio
				end
			end
		end
	end
	
	if self.spec_motorized.differentials and #self.spec_motorized.differentials==5 then
		local diffs = SplitBrakes.getDiffs(self)
		self.backDiff1 = diffs[1]
		self.midBackDiff = diffs[2]
		self.backDiff2 = diffs[3]
	end
end

function SplitBrakes:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
    if not (self.isClient and isActiveForInputIgnoreSelection) then return end
    local spec = self.spec_splitBrakes
    self:clearActionEventsTable(spec.actionEvents)
    spec.actionEventIds = {}
	
    -- Linke Bremse
    local _, idL = self:addActionEvent(spec.actionEvents, "FS25_SPLIT_BRAKE_LEFT", self, SplitBrakes.actionBrakeLeft, false, false, true, true, nil)
    g_inputBinding:setActionEventTextVisibility(idL, false)
	table.insert(spec.actionEventIds, idL)

    -- Rechte Bremse
    local _, idR = self:addActionEvent(spec.actionEvents, "FS25_SPLIT_BRAKE_RIGHT", self, SplitBrakes.actionBrakeRight, false, false, true, true, nil)
    g_inputBinding:setActionEventTextVisibility(idR, false)
	table.insert(spec.actionEventIds, idR)
end

function SplitBrakes.actionBrakeLeft(self, actionName, inputValue)
    local isActive = (inputValue == 1)
    if self.brakeLeftActive ~= isActive then
        self.brakeLeftActive = isActive
        if self.isClient and g_client ~= nil then
            g_client:getServerConnection():sendEvent(SplitBrakesSyncEvent.new(self, self.brakeLeftActive, self.brakeRightActive))
        end
        self:raiseDirtyFlags(self.spec_splitBrakes.dirtyFlag)
    end
end

function SplitBrakes.actionBrakeRight(self, actionName, inputValue)
    local isActive = (inputValue == 1)
    if self.brakeRightActive ~= isActive then
        self.brakeRightActive = isActive
        if self.isClient and g_client ~= nil then
            g_client:getServerConnection():sendEvent(SplitBrakesSyncEvent.new(self, self.brakeLeftActive, self.brakeRightActive))
        end
        self:raiseDirtyFlags(self.spec_splitBrakes.dirtyFlag)
    end
end

function SplitBrakes:onUpdate(dt)
	if self.setSplitBrakesInactive then return end
	
	--Geschwindigkeitsbegrenzung: Wenn schneller als 15 km/h nicht aktivieren
	if self.brakeLeftActive == false and self.brakeRightActive == false then
		self.brakeActive = 0
	elseif self.brakeLeftActive == true and self.brakeRightActive == false then
		self.brakeActive = 1
	elseif self.brakeLeftActive == false and self.brakeRightActive == true then
		self.brakeActive = 2
	elseif self.brakeLeftActive == true and self.brakeRightActive == true then
		self.brakeActive = 3
	end
	
	if self:getLastSpeed()>15 and self.brakeActive ~= 0 then
		g_currentMission:showBlinkingWarning(g_i18n:getText("text_FS25_SPLIT_BRAKE_SPEED_WARNING"), 1500)
		return 
	end
	
	if self.normalBrakeForce == nil then
		self.normalBrakeForce = self:getBrakeForce()
		self.brakeForceLeft = self.normalBrakeForce
		self.brakeForceRight = self.normalBrakeForce
	end
	
	if (self.brakeLeftActive == false or (self.spec_drivable.axisForward == 0 and math.abs(self.wheelRpmLeft) < 0.015)) and self.smoothBrakeLeft > 0 then
		self.smoothBrakeLeft = self.smoothBrakeLeft - 0.0025
		self.brakeForceLeft = self.normalBrakeForce
	end
	if (self.brakeRightActive == false or (self.spec_drivable.axisForward == 0 and math.abs(self.wheelRpmRight) < 0.015)) and self.smoothBrakeRight > 0 then
		self.smoothBrakeRight = self.smoothBrakeRight - 0.0025
		self.brakeForceRight = self.normalBrakeForce
	end
	
	if self.brakeLeftActive then		-- Hinterrad links bremsen
		local minAxleSpeed = 0
		tireCount = #self.spec_splitBrakes.leftRear
		for i=1, tireCount do
			local axleSpeed = getWheelShapeAxleSpeed(self.spec_splitBrakes.leftRear[i].node, self.spec_splitBrakes.leftRear[i].physics.wheelShape) -- rad/s
			minAxleSpeed = math.max(minAxleSpeed, math.abs(axleSpeed))
		end
		self.wheelRpmLeft = minAxleSpeed * 60 / (2 * math.pi)
		if (tireCount == 1 and math.abs(self.wheelRpmLeft) > 0.015) or (tireCount == 2 and math.abs(self.wheelRpmLeft) > 0.5) then
			if self.smoothBrakeLeft < 1 then
				self.smoothBrakeLeft = self.smoothBrakeLeft + 0.0085
			end
			self.brakeForceLeft = self.normalBrakeForce*SplitBrakes.BrakeForceMultiplikator*self.smoothBrakeLeft
		elseif self.smoothBrakeLeft > 0 then
			self.smoothBrakeLeft = self.smoothBrakeLeft - 0.0025
		end
		for i=1, tireCount do
			setWheelShapeProps(self.spec_splitBrakes.leftRear[i].node, self.spec_splitBrakes.leftRear[i].physics.wheelShape, 0, self.brakeForceLeft, self.spec_splitBrakes.leftRear[i].physics.steeringAngle, self.spec_splitBrakes.leftRear[i].physics.rotationDamping)
		end
	end
	if self.brakeRightActive then 		-- Hinterrad rechts bremsen
		local minAxleSpeed = 0
		local tireCount = #self.spec_splitBrakes.rightRear
		for i=1, tireCount do
			local axleSpeed = getWheelShapeAxleSpeed(self.spec_splitBrakes.rightRear[i].node, self.spec_splitBrakes.rightRear[i].physics.wheelShape) -- rad/s
			minAxleSpeed = math.max(minAxleSpeed, math.abs(axleSpeed))
		end
		self.wheelRpmRight = minAxleSpeed * 60 / (2 * math.pi)
		if (tireCount == 1 and math.abs(self.wheelRpmRight) > 0.015) or (tireCount == 2 and math.abs(self.wheelRpmRight) > 0.5) then
			if self.smoothBrakeRight < 1 then
				self.smoothBrakeRight = self.smoothBrakeRight + 0.0085
			end
			self.brakeForceRight = self.normalBrakeForce * SplitBrakes.BrakeForceMultiplikator * self.smoothBrakeRight
		elseif self.smoothBrakeRight > 0 then
			self.smoothBrakeRight = self.smoothBrakeRight - 0.0025
		end
		for i=1, tireCount do
			setWheelShapeProps(self.spec_splitBrakes.rightRear[i].node, self.spec_splitBrakes.rightRear[i].physics.wheelShape, 0, self.brakeForceRight, self.spec_splitBrakes.rightRear[i].physics.steeringAngle, self.spec_splitBrakes.rightRear[i].physics.rotationDamping)
		end
	end
	
	-- Falls EnhancedVehicle aktiviert ist, werden Ausgangswerte gesichert
	if SplitBrakes.existEnhancedVehicle and self.enableSafeVdata then
		if self.vData.want[3] == nil then
			self.tempMiddleDiffWant = 1
		else
			self.tempMiddleDiffWant = self.vData.want[3]
		end
		self.enableSafeVdata = false
	end
	
	-- Falls EnhancedVehicle aktiviert ist, muss das Mitteldifferential aktiviert sein
	if SplitBrakes.existEnhancedVehicle and self.brakeActive ~= 0 then
		self.vData.want[3] = 1
	end
	
	-- Diferentiale modifizieren
	if self.brakeActive ~= self.brakeActiveTemp then
		self.brakeActiveTemp = self.brakeActive
		SplitBrakes:updateModdedDiff(self)
	end
	
	-- EnhancedVehicle zurückstellen
	if SplitBrakes.existEnhancedVehicle and self.enableSafeVdata == false and self.brakeLeftActive == false and self.brakeRightActive == false then
		self.vData.want[3] = self.tempMiddleDiffWant
		self.enableSafeVdata = true
	end
	
	-- Reibung der Reifen anpassen
	if self.brakeActive ~= 0 then
		SplitBrakes:updateFrictionFront(self)
		SplitBrakes:updateFrictionRear(self)
	else
		SplitBrakes:resetFriction(self)
	end
	SplitBrakes:updateMotorTorqueAndSpeedScale(self)
end

function SplitBrakes:getDiffs()
	specDiff=self.spec_motorized.differentials
	local midBackDiff = nil
	local backDiff1 = nil
	local backDiff2 = nil
	
	for i=1, #specDiff do
		if specDiff[i].diffIndex1IsWheel == false then
			if specDiff[specDiff[i].diffIndex1+1].diffIndex1IsWheel == true and specDiff[specDiff[i].diffIndex2+1].diffIndex1IsWheel == true then
				midBackDiff = specDiff[i]
				midBackDiff.diffIndex=i-1
			end
		elseif specDiff[i].diffIndex1IsWheel == true then 
			if specDiff[i].diffIndex1 == self.spec_splitBrakes.leftRear[1].physics.wheelIndex then
				backDiff1 = specDiff[i]
				backDiff1.diffIndex=i-1
			elseif specDiff[i].diffIndex1 == self.spec_splitBrakes.leftRear[2].physics.wheelIndex then
				backDiff2 = specDiff[i]
				backDiff2.diffIndex=i-1
			end
		end
	end
	return {backDiff1, midBackDiff, backDiff2}
end

function SplitBrakes:updateModdedDiff(self)
	local numDiffs = #self.spec_motorized.differentials
	
	if self.brakeLeftActive then												-- Hinterdifferential: Last auf rechtes Rad
		if 		numDiffs == 1 then
			updateDifferential(self.rootNode, 0, 1-SplitBrakes.TorqueRatioModded, self.diff.maxSpeedRatio[1]*SplitBrakes.MaxSpeedRatioFaktor)
		elseif 	numDiffs == 3 then
			updateDifferential(self.rootNode, 1, 1-SplitBrakes.TorqueRatioModded, self.diff.maxSpeedRatio[1]*SplitBrakes.MaxSpeedRatioFaktor)
		elseif 	numDiffs == 5 then
			updateDifferential(self.rootNode, self.backDiff1.diffIndex, 1-SplitBrakes.TorqueRatioModded, self.diff.maxSpeedRatio[1]*SplitBrakes.MaxSpeedRatioFaktor)
			updateDifferential(self.rootNode, self.backDiff2.diffIndex, 1-SplitBrakes.TorqueRatioModded, self.diff.maxSpeedRatio[1]*SplitBrakes.MaxSpeedRatioFaktor)
		elseif numDiffs == 7 then
            updateDifferential(self.rootNode, 5, 1-SplitBrakes.TorqueRatioModded, self.diff.maxSpeedRatio[2]*SplitBrakes.MaxSpeedRatioFaktor)
        end
	end	
	if self.brakeRightActive then												-- Hinterdifferential: Last auf linkes Rad
		if 		numDiffs == 1 then
			updateDifferential(self.rootNode, 0, SplitBrakes.TorqueRatioModded, self.diff.maxSpeedRatio[1]*SplitBrakes.MaxSpeedRatioFaktor)
		elseif 	numDiffs == 3 then
			updateDifferential(self.rootNode, 1, SplitBrakes.TorqueRatioModded, self.diff.maxSpeedRatio[1]*SplitBrakes.MaxSpeedRatioFaktor)
		elseif 	numDiffs == 5 then
			updateDifferential(self.rootNode, self.backDiff1.diffIndex, SplitBrakes.TorqueRatioModded, self.diff.maxSpeedRatio[1]*SplitBrakes.MaxSpeedRatioFaktor)
			updateDifferential(self.rootNode, self.backDiff2.diffIndex, SplitBrakes.TorqueRatioModded, self.diff.maxSpeedRatio[1]*SplitBrakes.MaxSpeedRatioFaktor)
		elseif numDiffs == 7 then
            updateDifferential(self.rootNode, 5, SplitBrakes.TorqueRatioModded, self.diff.maxSpeedRatio[2]*SplitBrakes.MaxSpeedRatioFaktor)
        end
	end
	if self.brakeLeftActive == false and self.brakeRightActive == false then	-- Hinterdifferential zurückstellen
		if 		numDiffs == 1 then
			updateDifferential(self.rootNode, 0, self.diff.torqueRatio[1], self.diff.maxSpeedRatio[1]*SplitBrakes.MaxSpeedRatioFaktor) 				
		elseif 	numDiffs == 3 then
			updateDifferential(self.rootNode, 1, self.diff.torqueRatio[1], self.diff.maxSpeedRatio[1]*SplitBrakes.MaxSpeedRatioFaktor)
		elseif 	numDiffs == 5 then
			updateDifferential(self.rootNode, self.backDiff1.diffIndex, self.diff.torqueRatio[1], self.diff.maxSpeedRatio[1]*SplitBrakes.MaxSpeedRatioFaktor)
			updateDifferential(self.rootNode, self.backDiff2.diffIndex, self.diff.torqueRatio[1], self.diff.maxSpeedRatio[1]*SplitBrakes.MaxSpeedRatioFaktor)
		elseif numDiffs == 7 then
            updateDifferential(self.rootNode, 5, self.diff.torqueRatio[2], self.diff.maxSpeedRatio[2]*SplitBrakes.MaxSpeedRatioFaktor)
        end
	end
end

function SplitBrakes:updateFrictionFront(self)
	-- Reifen vorne: Reibung reduzieren
	if getWheelShapeContactForce(self.spec_splitBrakes.leftFront[1].node, self.spec_splitBrakes.leftFront[1].physics.wheelShape) == nil or getWheelShapeContactForce(self.spec_splitBrakes.rightFront[1].node, self.spec_splitBrakes.rightFront[1].physics.wheelShape) == nil then
		GripIndex = WheelsUtil.getTireType("LOWGRIP_FRONT")
		frictionMult = SplitBrakes.frictionFrontMultiplikatorLow
	elseif getWheelShapeContactForce(self.spec_splitBrakes.leftFront[1].node, self.spec_splitBrakes.leftFront[1].physics.wheelShape) < 0.1 or getWheelShapeContactForce(self.spec_splitBrakes.rightFront[1].node, self.spec_splitBrakes.rightFront[1].physics.wheelShape) <0.1 then
		GripIndex = WheelsUtil.getTireType("LOWGRIP_FRONT")
		frictionMult = SplitBrakes.frictionFrontMultiplikatorLow
	else
		GripIndex = WheelsUtil.getTireType("HIGHGRIP_FRONT")
		frictionMult = SplitBrakes.frictionFrontMultiplikatorHigh
	end
	for _, z in ipairs(self.spec_splitBrakes.leftFront) do
		z.physics.tireType = GripIndex
	end
	for _, z in ipairs(self.spec_splitBrakes.rightFront) do
		z.physics.tireType = GripIndex
	end
end

function SplitBrakes:updateFrictionRear(self)
	-- Reifen hinten: Reibung erhöhen
	local frictionMult = SplitBrakes.frictionRearMultiplikator
	local GripIndex = WheelsUtil.getTireType("HIGHGRIP_REAR")
	for _, z in ipairs(self.spec_splitBrakes.leftRear) do
		z.physics.tireType = GripIndex
	end
	for _, z in ipairs(self.spec_splitBrakes.rightRear) do
		z.physics.tireType = GripIndex
	end
end

function SplitBrakes:resetFriction(self)
	-- Reifen vorne und hinten: Reibung zurückstellen
	for _, z in ipairs(self.spec_splitBrakes.leftRear) do
		z.physics.tireType = z.physics.originalTireType
	end
	for _, z in ipairs(self.spec_splitBrakes.rightRear) do
		z.physics.tireType = z.physics.originalTireType
	end
	for _, z in ipairs(self.spec_splitBrakes.leftFront) do
		z.physics.tireType = z.physics.originalTireType
	end
	for _, z in ipairs(self.spec_splitBrakes.rightFront) do
		z.physics.tireType = z.physics.originalTireType
	end
end

function SplitBrakes:updateMotorTorqueAndSpeedScale(self)
	local spec = self.spec_motorized
	local motor = self.spec_motorized.motor
	local torques, rotationSpeeds = motor:getTorqueAndSpeedValues()
	local scaledTorques = {}
	for i, v in ipairs(torques) do
		scaledTorques[i] = v * SplitBrakes.TorqueScaleMotor
	end
	local scaledRotationSpeeds = {}
	for i, v in ipairs(rotationSpeeds) do
		scaledRotationSpeeds[i] = v * SplitBrakes.RotationSpeedsScaleMotor
	end
	local rpm = spec.motor:getLastModulatedMotorRpm()
	if self.brakeActive ~= 0 and spec.motor.lastAcceleratorPedal ~= 0 and rpm < motor:getMaxRpm()*0.7 then
		rpm=rpm+3
		setMotorProperties(spec.motorizedNode,rpm*math.pi/30, motor:getMaxRpm()*math.pi/30, motor:getRotInertia(), motor:getDampingRateFullThrottle(), motor:getDampingRateZeroThrottleClutchEngaged(), motor:getDampingRateZeroThrottleClutchDisengaged(), scaledRotationSpeeds, scaledTorques)
	else
		setMotorProperties(spec.motorizedNode, motor:getMinRpm()*math.pi/30, motor:getMaxRpm()*math.pi/30, motor:getRotInertia(), motor:getDampingRateFullThrottle(), motor:getDampingRateZeroThrottleClutchEngaged(), motor:getDampingRateZeroThrottleClutchDisengaged(), rotationSpeeds, torques)
	end
	
end