AllRound_ExtensionSetGet = {};

function AllRound_ExtensionSetGet:setMiniMapState()	
	if g_currentMission.hlUtils:getFullSize(true,true) then return;end;
	local inGameMapState = g_currentMission.hlUtils.getIngameMapState();
	if AllRound_Extension.values.miniMapState[inGameMapState] then return;end;	
	local setNew = false;
	function setState(state)
		g_currentMission.hud.ingameMap.layout:deactivate();
		
		g_currentMission.hud.ingameMap.state = state;
		g_currentMission.hud.ingameMap.layout = g_currentMission.hud.ingameMap.layouts[state];
		g_currentMission.hud.ingameMap.layout:activate();
				
		g_inputBinding:setActionEventTextVisibility(g_currentMission.hud.ingameMap.toggleMapSizeEventId, g_currentMission.hud.ingameMap.layout:getShowsToggleActionText())
		g_gameSettings:setValue("ingameMapState", state, true)
			
	end;	
	if inGameMapState <= 4 then			
		if AllRound_Extension.values.miniMapState[inGameMapState] ~= nil and not AllRound_Extension.values.miniMapState[inGameMapState] then 		
			for a=inGameMapState, 4 do
				if AllRound_Extension.values.miniMapState[a] ~= nil and AllRound_Extension.values.miniMapState[a] then					
					setState(a)
					setNew = true;
					break;					
				end;
			end;
		end;
		if not setNew then setState(1);end;
	end;	
	return;	
end;

function AllRound_ExtensionSetGet:setTemperaturIcon()	
	g_currentMission.hud.gameInfoDisplay:setTemperatureVisible(AllRound_Extension.values.temperatur.icon);		
end;

function AllRound_ExtensionSetGet.updateTemperature(self)
	if not self.showTemperature or not AllRound_Extension.values.temperatur.icon or g_currentMission.hlUtils:getFullSize(true,true) then return;end;	
	local minTemp, maxTemp = self.environment.weather:getCurrentMinMaxTemperatures();
	local currentTemp = self.environment.weather:getCurrentTemperature();
	local color = GameInfoDisplay.COLOR.ICON;	
	if AllRound_Extension.values.temperatur.iconColor then
		if currentTemp >= 0 and currentTemp <= 5 then
			color = g_currentMission.hlUtils.getColor("royalBlue", true);
		elseif currentTemp > 5 and currentTemp <= 10 then
			color = g_currentMission.hlUtils.getColor("green", true);
		elseif currentTemp > 10 and currentTemp <= 20 then
			color = g_currentMission.hlUtils.getColor("yellow", true);
		elseif currentTemp > 20 and currentTemp <= 30 then
			color = g_currentMission.hlUtils.getColor("darkYellow", true);	
		elseif currentTemp > 30 then
			color = g_currentMission.hlUtils.getColor("red", true);
		end;
	end;
	g_currentMission.hlUtils.setBackgroundColor(g_currentMission.hud.gameInfoDisplay.temperatureIconStable.overlay, color);
	g_currentMission.hlUtils.setBackgroundColor(g_currentMission.hud.gameInfoDisplay.temperatureIconRising.overlay, color);
	g_currentMission.hlUtils.setBackgroundColor(g_currentMission.hud.gameInfoDisplay.temperatureIconDropping.overlay, color);
	--default--
	if AllRound_Extension.values.temperatur.data.optiSize == nil then 
		local bgX, bgY, bgW, bgH = g_currentMission.hlUtils.getOverlay(g_currentMission.hud.gameInfoDisplay.temperatureBox.overlay);
		local iX, iY, iW, iH = g_currentMission.hlUtils.getOverlay(g_currentMission.hud.gameInfoDisplay.temperatureIconRising.overlay);
		AllRound_Extension.values.temperatur.data.defaultTxtsize = self.temperatureTextSize;
		AllRound_Extension.values.temperatur.data.optiSize = g_currentMission.hlUtils.optiHeightSize((bgY+bgH)-(iY+iH)-0.0005, "Äg", self.temperatureTextSize); --g_currentMission.hlUtils.optiWidthSize(bgW-(iW-0.006), "-50°/50°", self.temperatureTextSize);
		AllRound_Extension.values.temperatur.data.textHeight = getTextHeight(AllRound_Extension.values.temperatur.data.optiSize, utf8Substr("-50°", 0));
		AllRound_Extension.values.temperatur.data.iconX = iX;		
	end;
	--default--
	--if AllRound_Extension.values.temperatur.text then
		--fix °--	
		--self.temperatureDayText = string.format("%d°/%d°", minTemp, maxTemp);
		--self.temperatureNightText = string.format("%d°", currentTemp)
		self.temperatureDayText = string.format("%d°", maxTemp);
		self.temperatureNightText = string.format("%d°", minTemp);
		--fix °--
	--else
	--	self.temperatureDayText = "";
	--	self.temperatureNightText = "";
	--end;
end;

function AllRound_ExtensionSetGet.drawTemperatureTxt(self)
	if not self.showTemperature or not AllRound_Extension.values.temperatur.icon or not AllRound_Extension.values.temperatur.current or g_currentMission.hlUtils:getFullSize(true,true) then return;end;
	if AllRound_Extension.values.temperatur.data.optiSize ~= nil then
		local currentTemp = self.environment.weather:getCurrentTemperature();
		local bgX, bgY, bgW, bgH = g_currentMission.hlUtils.getOverlay(g_currentMission.hud.gameInfoDisplay.temperatureBox.overlay);
		local color = GameInfoDisplay.COLOR.ICON;
		if AllRound_Extension.values.temperatur.currentColor then
			if currentTemp >= 0 and currentTemp <= 5 then
				color = g_currentMission.hlUtils.getColor("royalBlue", true);
			elseif currentTemp > 5 and currentTemp <= 10 then
				color = g_currentMission.hlUtils.getColor("green", true);
			elseif currentTemp > 10 and currentTemp <= 20 then
				color = g_currentMission.hlUtils.getColor("yellow", true);
			elseif currentTemp > 20 and currentTemp <= 30 then
				color = g_currentMission.hlUtils.getColor("darkYellow", true);	
			elseif currentTemp > 30 then
				color = g_currentMission.hlUtils.getColor("red", true);
			end;
		end;
		local txt = g_i18n:formatTemperature(currentTemp, 0, false);
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextColor(unpack(color));
		renderText(AllRound_Extension.values.temperatur.data.iconX, bgY+bgH-AllRound_Extension.values.temperatur.data.textHeight, AllRound_Extension.values.temperatur.data.optiSize, tostring(txt));
		setTextAlignment(0);
	end;	
end;

function AllRound_ExtensionSetGet.updateTime(self)
	if not self.showTime or g_currentMission.hlUtils:getFullSize(true,true) then return;end;
	local color = GameInfoDisplay.COLOR.ICON;
	if AllRound_Extension.values.ingameTime.iconColor then
		if self.missionInfo.timeScale > 1 then
			color = g_currentMission.hlUtils.getColor("orangeRed", true);
		elseif self.missionInfo.timeScale < 1 then
			color = g_currentMission.hlUtils.getColor("yellow", true);
		end;
	end;
	g_currentMission.hlUtils.setBackgroundColor(g_currentMission.hud.gameInfoDisplay.timeScaleArrow.overlay, color);
	g_currentMission.hlUtils.setBackgroundColor(g_currentMission.hud.gameInfoDisplay.timeScaleArrowFast.overlay, color);		
end;

function AllRound_ExtensionSetGet.drawTimeText(self)
	AllRound_Extension.testString[1] = "true"
	if not self.showTime or g_currentMission.hlUtils:getFullSize(true,true) then return;end;
	if AllRound_Extension.values.ingameTime.playDays then
		local bgX, bgY, bgW, bgH = g_currentMission.hlUtils.getOverlay(g_currentMission.hud.gameInfoDisplay.timeBox.overlay);
		local iX, iY, iW, iH = g_currentMission.hlUtils.getOverlay(self.clockElement.overlay);	
		local color = GameInfoDisplay.COLOR.ICON;		
		local playDays = g_i18n:getText("ui_day").. " ".. tostring(g_currentMission.environment.currentDay);
		local day = g_currentMission.hlUtils.getIngameDayString();
		local txt = day.. "/".. playDays;
		if AllRound_Extension.values.ingameTime.data.textHeight == nil then
			AllRound_Extension.values.ingameTime.data.optiSize = g_currentMission.hlUtils.optiHeightSize((bgY+bgH)-(iY+iH)-0.0005, tostring(txt), self.timeScaleTextSize);			
			AllRound_Extension.values.ingameTime.data.textHeight = getTextHeight(AllRound_Extension.values.ingameTime.data.optiSize, tostring(txt));			
		end;
		local optiSize = g_currentMission.hlUtils.optiWidthSize(bgW-(iX-bgX), tostring(txt), AllRound_Extension.values.ingameTime.data.optiSize); 
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextColor(unpack(color));
		renderText(iX, bgY+bgH-AllRound_Extension.values.ingameTime.data.textHeight, optiSize, tostring(txt));
		setTextAlignment(0);
	end;
end;

function AllRound_ExtensionSetGet.drawMoneyText(self)
	if not self.showMoney or g_currentMission.hlUtils:getFullSize(true,true) then return;end;
	if AllRound_Extension.values.realDayTime.dayTime then
		local bgX, bgY, bgW, bgH = g_currentMission.hlUtils.getOverlay(g_currentMission.hud.gameInfoDisplay.moneyBox.overlay);
		local iX, iY, iW, iH = g_currentMission.hlUtils.getOverlay(self.moneyIconOverlay);	
		local color = GameInfoDisplay.COLOR.ICON;
		if AllRound_Extension.values.realDayTime.textColor > 0 then color = g_currentMission.hlUtils.getColor(AllRound_Extension.values.realDayTime.colorText[AllRound_Extension.values.realDayTime.textColor], true);end;
		local day = g_currentMission.hlUtils.getRealDayString(AllRound_Extension.values.realDayTime.dayLarge);
		local realTime = g_currentMission.hlUtils.getRealTime(true,true,false,AllRound_Extension.values.realDayTime.format12);
		local txt = day.. " ".. realTime;
		if AllRound_Extension.values.realDayTime.date then			
			txt = txt.. " / ".. tostring(getDate("%d")).. ".".. tostring(getDate("%m")).. ".".. tostring(getDate("%Y"));
		end;
		if AllRound_Extension.values.realDayTime.data.textHeight == nil then
			AllRound_Extension.values.realDayTime.data.optiSize = g_currentMission.hlUtils.optiHeightSize((bgY+bgH)-(iY+iH)-0.0005, tostring(txt), self.moneyTextSize);			
			AllRound_Extension.values.realDayTime.data.textHeight = getTextHeight(AllRound_Extension.values.realDayTime.data.optiSize, tostring(txt));			
		end;
		local optiSize = g_currentMission.hlUtils.optiWidthSize(bgW-(iX-bgX), tostring(txt), AllRound_Extension.values.realDayTime.data.optiSize); 
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextColor(unpack(color));
		renderText(iX, bgY+bgH-AllRound_Extension.values.realDayTime.data.textHeight, optiSize, tostring(txt));
		setTextAlignment(0);
	end;
end;

function AllRound_ExtensionSetGet.drawDateText(self)
	if not self.showDate or g_currentMission.hlUtils:getFullSize(true,true) then return;end;
	if AllRound_Extension.values.season.yearsPlayed then
		local bgX, bgY, bgW, bgH = g_currentMission.hlUtils.getOverlay(g_currentMission.hud.gameInfoDisplay.dateBox.overlay);
		local iX, iY, iW, iH = g_currentMission.hlUtils.getOverlay(self.seasonOverlay);
		local color = GameInfoDisplay.COLOR.ICON;
		local txt = string.format(g_i18n:getText("box_year_season"), self.environment.currentYear);	
		if AllRound_Extension.values.season.data.textHeight == nil then
			AllRound_Extension.values.season.data.optiSize = g_currentMission.hlUtils.optiHeightSize((bgY+bgH)-(iY+iH)-0.0005, tostring(txt), self.monthTextSize);			
			AllRound_Extension.values.season.data.textHeight = getTextHeight(AllRound_Extension.values.season.data.optiSize, tostring(txt));
		end;
		local optiSize = g_currentMission.hlUtils.optiWidthSize(bgW-(iX-bgX), tostring(txt), AllRound_Extension.values.season.data.optiSize); 
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextColor(unpack(color));
		renderText(iX, bgY+bgH-AllRound_Extension.values.season.data.textHeight, optiSize, tostring(txt));
		setTextAlignment(0);
	end;
end;

function AllRound_ExtensionSetGet:loadGameInfoDisplay()
	if AllRound_Extension:getDetiServer() then return;end;
	GameInfoDisplay.updateTemperature = Utils.appendedFunction(GameInfoDisplay.updateTemperature, AllRound_ExtensionSetGet.updateTemperature);
	GameInfoDisplay.drawTemperatureText = Utils.appendedFunction(GameInfoDisplay.drawTemperatureText, AllRound_ExtensionSetGet.drawTemperatureTxt);
	GameInfoDisplay.updateTime = Utils.appendedFunction(GameInfoDisplay.updateTime,AllRound_ExtensionSetGet.updateTime);
	GameInfoDisplay.drawTimeText = Utils.appendedFunction(GameInfoDisplay.drawTimeText, AllRound_ExtensionSetGet.drawTimeText);
	GameInfoDisplay.drawMoneyText = Utils.appendedFunction(GameInfoDisplay.drawMoneyText, AllRound_ExtensionSetGet.drawMoneyText);
	GameInfoDisplay.drawDateText = Utils.appendedFunction(GameInfoDisplay.drawDateText, AllRound_ExtensionSetGet.drawDateText);
end;
---------------
function AllRound_ExtensionSetGet:setTemporaryData(newUiScale)
	if not g_currentMission.hud.isVisible or not g_currentMission.hud.gameInfoDisplay.isVisible then return;end;
	local otherModsXdif = 0;
	local bgX, bgY, bgW, bgH = 0,0,0,0;	
	if AllRound_Extension.values.temporaryData.textHeight == nil or newUiScale then
		local height = (g_currentMission.hud.gameInfoDisplay.y+g_currentMission.hud.gameInfoDisplay.infoBgScale.height)-(g_currentMission.hud.gameInfoDisplay.calendarIcon.y+g_currentMission.hud.gameInfoDisplay.calendarIcon.height);
		AllRound_Extension.values.temporaryData.optiSize = g_currentMission.hlUtils.optiHeightSize(height-(g_currentMission.hlHudSystem.screen.difHeight*3), tostring("Äg"), g_currentMission.hud.gameInfoDisplay.calendarTextSize)-0.002;
		AllRound_Extension.values.temporaryData.textHeight = getTextHeight(AllRound_Extension.values.temporaryData.optiSize, tostring("Äg"));
		AllRound_Extension.values.temporaryData.y = g_currentMission.hud.gameInfoDisplay.y-AllRound_Extension.values.temporaryData.textHeight+g_currentMission.hlHudSystem.screen.difHeight;
		AllRound_Extension.values.temporaryData.width = g_currentMission.hud.gameInfoDisplay.infoBgScale.width-g_currentMission.hud.gameInfoDisplay.moneyBgScale.width; --money bg not fix :-(
	end;
	if AllRound_Extension.values.ingameTime.timeScaleColor then
		local color = g_currentMission.hlUtils.getColor("ls25", true);
		if g_currentMission.missionInfo.timeScale > 1 then
			color = g_currentMission.hlUtils.getColor("orangeRed", true);
		elseif g_currentMission.missionInfo.timeScale < 1 and g_currentMission.missionInfo.timeScale > 0 then
			color = g_currentMission.hlUtils.getColor("yellow", true);
		elseif g_currentMission.missionInfo.timeScale <= 0 then
			color = g_currentMission.hlUtils.getColor("red", true);
		end;
		g_currentMission.hlUtils.setBackgroundColor(g_currentMission.hud.gameInfoDisplay.fastForwardIcon, color);
	end;
	if AllRound_Extension.values.ingameTime.clickFrame and g_currentMission.hud.gameInfoDisplay.clockHandMinute.visible and not g_currentMission.hlUtils.dragDrop.on and g_currentMission.hlUtils.isMouseCursor then --not active
		local master = g_currentMission:getIsServer() or g_currentMission.isMasterUser;
		if master and g_localPlayer ~= nil and g_localPlayer.isOwner and g_localPlayer.inputComponent ~= nil and not g_localPlayer.inputComponent.locked then			
			local x, y, w, h = g_currentMission.hlUtils.getOverlay(g_currentMission.hud.gameInfoDisplay.infoBgLeft);			
			local endPosX = g_currentMission.hud.gameInfoDisplay.fastForwardIcon.x+(g_currentMission.hud.gameInfoDisplay.fastForwardIcon.width*2);
			x = g_currentMission.hud.gameInfoDisplay.clockIcon.x;			
			local posY = g_currentMission.hud.gameInfoDisplay.clockIcon.y;
			local width = endPosX-x;
			local height = h-(posY-y);
			local inArea = g_currentMission.hlUtils.mouseIsInArea(nil, nil, x, x+width, posY, posY+height);
			if g_currentMission.hlHudSystem.infoDisplay.on and inArea then 
				g_currentMission.hlHudSystem:addMouseAcceptsInfo( {acceptsMouse={"left","middle","right"}} );
			end;
			if not g_currentMission.hlUtils:disableInArea() and inArea then g_currentMission.hlHudSystem:setClickArea( {x, x+width, posY, posY+height, onClick=AllRound_Extension_MouseKeyEvents.onClickArea, whatClick="AllRound_Extension_OtherAreas", whereClick="ingameTimeFrame_", ownTable={}} );end;
		end;	
	end;
	local dropTxt = "";
	local dropTxtWidth = 0;
	local nextPosX = 0;
	function setDropText(posX,color,size,align)
		setTextAlignment(align or RenderText.ALIGN_CENTER);
		setTextColor(unpack(color));
		renderText(posX, AllRound_Extension.values.temporaryData.y, size or AllRound_Extension.values.temporaryData.optiSize, tostring(dropTxt));
		renderText(posX, AllRound_Extension.values.temporaryData.y, size or AllRound_Extension.values.temporaryData.optiSize, tostring(dropTxt));
		setTextAlignment(0);
		setTextColor(1, 1, 1, 1);
	end;	
	if (AllRound_Extension.values.realDayTime.dayTime or AllRound_Extension.values.realDayTime.date) and g_currentMission.hud.gameInfoDisplay.clockHandMinute.visible then		
		local day = g_currentMission.hlUtils.getRealDayString(AllRound_Extension.values.realDayTime.dayLarge);	
		local realTime = g_currentMission.hlUtils.getRealTime(true,true,false,AllRound_Extension.values.realDayTime.format12);
		dropTxt = day.. " ".. realTime;		
		if AllRound_Extension.values.realDayTime.dayTime and AllRound_Extension.values.realDayTime.date then			
			dropTxt = dropTxt.. " / ".. tostring(getDate("%d")).. ".".. tostring(getDate("%m")).. ".".. tostring(getDate("%y"));
		elseif AllRound_Extension.values.realDayTime.date then
			dropTxt = tostring(getDate("%d")).. ".".. tostring(getDate("%m")).. ".".. tostring(getDate("%Y"));
		end;		
	end;
	if dropTxt:len() > 0 then
		local temp1PosX = g_currentMission.hud.gameInfoDisplay.fastForwardArrowIcon.x;
		local temp2PosX = g_currentMission.hud.gameInfoDisplay.clockHandHour.x+g_currentMission.hud.gameInfoDisplay.clockHandHour.width;
		local width = temp1PosX-temp2PosX;
		local posX = temp2PosX+(width/2);
		local color = g_currentMission.hlUtils.getColor(AllRound_Extension.values.textColor[AllRound_Extension.values.realDayTime.textColor], true);
		setDropText(posX,color);
	end;
	local yearsPlayedTxt = "";
	local playDaysTxt = "";
	local separatorWidth = g_currentMission.hlUtils.getTextWidth(" | ", AllRound_Extension.values.temporaryData.optiSize, false);
	dropTxt = "";
	dropTxtWidth = 0;
	local color = 1;
	if AllRound_Extension.values.season.yearsPlayed and g_currentMission.hud.gameInfoDisplay.calendarIcon.visible then
		yearsPlayedTxt = string.format(g_i18n:getText("box_years_season"), g_currentMission.environment.currentYear);
		yearsPlayedTxtWidth = g_currentMission.hlUtils.getTextWidth(yearsPlayedTxt, AllRound_Extension.values.temporaryData.optiSize, false);
	end;
	if AllRound_Extension.values.ingameTime.playDays and g_currentMission.hud.gameInfoDisplay.calendarIcon.visible then
		local playDays = g_i18n:getText("ui_day").. " ".. tostring(g_currentMission.environment.currentDay);
		local day = g_currentMission.hlUtils.getIngameDayString();
		playDaysTxt = day.. "/".. playDays;
		playDaysTxtWidth = g_currentMission.hlUtils.getTextWidth(playDaysTxt, AllRound_Extension.values.temporaryData.optiSize, false);
	end;
	if yearsPlayedTxt:len() > 0 and playDaysTxt:len() > 0 then
		dropTxt = yearsPlayedTxt.. " | ".. playDaysTxt;
		dropTxtWidth = yearsPlayedTxtWidth+separatorWidth+playDaysTxtWidth;		
	elseif yearsPlayedTxt:len() > 0 then
		dropTxt = yearsPlayedTxt;
		dropTxtWidth = yearsPlayedTxtWidth;
	elseif playDaysTxt:len() > 0 then
		dropTxt = playDaysTxt;
		dropTxtWidth = playDaysTxtWidth;
	end;
	if dropTxt:len() > 0 then
		local posX = g_currentMission.hud.gameInfoDisplay.helpOffsetXCalendar-(g_currentMission.hud.gameInfoDisplay.calendarIcon.width/2);
		local color = g_currentMission.hlUtils.getColor(AllRound_Extension.values.textColor[AllRound_Extension.values.season.textColor], true);		
		setDropText(posX,color);	
	end;
	dropTxt = "";
	dropTxtWidth = 0;
	color = 1;
	
	if AllRound_Extension.values.weather.rainInfo and g_currentMission ~= nil and g_currentMission.environment ~= nil and g_currentMission.environment.weather ~= nil then
		if AllRound_Extension.otherMods.extendedGameInfoDisplay then otherModsXdif = g_currentMission.hud.gameInfoDisplay:scalePixelToScreenWidth(FS25_ExtendedGameInfoDisplay.ExtendedGameInfoDisplay.STRECH_GAME_INFO_DISPLAY);end;
		local posX = g_currentMission.hlUtils.getOverlay(g_currentMission.hud.gameInfoDisplay.infoBgLeft) - otherModsXdif;
		
		local weatherType = {RAIN=true,SNOW=true,HAIL=true,TWISTER=false};
		local env = g_currentMission.environment;
		local currentDay = env.currentMonotonicDay;		
		local day, dTime = env:getDayAndDayTime(env.dayTime + 21600000, env.currentMonotonicDay);
		local dayTime = env.dayTime;
		local durationTxt = "";
		
		local currentWeather = env.weather:getCurrentWeatherType();
		local nextWeather = env.weather:getNextWeatherType(day, dTime);
		local isRain = env.weather:getIsRaining() or env.weather:getIsHailing() or env.weather:getIsSnowing();
		
		local currentWeather_info = weatherType[WeatherType.getName(currentWeather)] ~= nil or isRain;
		local nextWeather_info = nextWeather ~= nil and weatherType[WeatherType.getName(nextWeather)] ~= nil;
		
		--by MissionsTimes Mod		
		function getMinutesLeft(data, isRunning) 
			if data == nil then
				return nil;
			end;
			
			local totalDayTime = 24 * 60 * 60 * 1000;

			local endDay = data.endDay;
			local endDayTime = data.endDayTime;

			local dayTimeDelta = 0;
			if endDayTime > dayTime then
				dayTimeDelta = endDayTime - dayTime;
			end;	
			if currentDay < endDay then
				dayTimeDelta = dayTime + (totalDayTime - endDayTime);
				currentDay = currentDay + 1;
			end

			dayTimeDelta = dayTimeDelta + (endDay - currentDay) * totalDayTime;

			local minutesLeft = dayTimeDelta / (1000 * 60);

			return minutesLeft;
		end;
		--by MissionsTimes Mod
		
		function getWeatherTime(current)
			local difTime = 1800000; --ca. 30 min +-
			if env.weather.forecastItems ~= nil then
				if current then
					if #env.weather.forecastItems >= 1 then
						local cW = env.weather.forecastItems[1];
						if cW ~= nil then
							local endDayTime = cW.startDayTime+cW.duration+difTime;
							local endDay = cW.startDay;
							local cWnew = AllRound_Extension.values.weather.data.endDayTime ~= nil and AllRound_Extension.values.weather.data.endDayTime ~= endDayTime or AllRound_Extension.values.weather.data.endDay ~= endDay;
							if AllRound_Extension.values.weather.data.rainDuration == nil or AllRound_Extension.values.weather.data.setData == nil or cWnew then
								--if endDayTime >= 86400000 then endDay = endDay+1;endDayTime = endDayTime-86400000;end;
								AllRound_Extension.values.weather.data.endDay = endDay;
								AllRound_Extension.values.weather.data.endDayTime = endDayTime;
								AllRound_Extension.values.weather.data.setData = true;								
							end;
							
							local endRain = g_i18n:formatMinutes(getMinutesLeft(AllRound_Extension.values.weather.data));
							
							if endRain ~= nil then								
								return "~".. endRain;								
							end;
						end;
					end;				
				else
					if #env.weather.forecastItems >= 2 then
						local nW = env.weather.forecastItems[2];
						if nW ~= nil then
							if AllRound_Extension.values.weather.data.rainDuration == nil then															
								AllRound_Extension.values.weather.data.rainDuration = nW.duration+difTime;
								AllRound_Extension.values.weather.data.durationMinutes = Utils.formatTime((AllRound_Extension.values.weather.data.rainDuration)/1000/60); --minutes
								AllRound_Extension.values.weather.data.endDay = nW.startDay;
								AllRound_Extension.values.weather.data.endDayTime = nW.startDayTime;								
							end;
							--local nextDay = 0;
							--if startDay > currentDay then nextDay = 86400000*(nW.startDay-currentDay);end;
							
							local durationMinutes = Utils.formatTime((AllRound_Extension.values.weather.data.rainDuration)/1000/60); --minutes
							
							local nextRain = g_i18n:formatMinutes(getMinutesLeft(AllRound_Extension.values.weather.data));
							
							if nextRain ~= nil then							
								--local startRain = (86400000-dayTime)+nW.startDayTime+nextDay;							
								
								--local nextRain = g_i18n:formatMinutes((startRain)/1000/60);
								
								return nextRain.. "/".. durationMinutes;
							end;
						end;
					end;
				end;
			end;
			return "";
		end;
		
		if currentWeather_info then
			dropTxt = getWeatherTime(true);			
		elseif nextWeather_info then
			dropTxt = getWeatherTime(false);			
		end;
		if dropTxt:len() > 0 then
			color = g_currentMission.hlUtils.getColor(AllRound_Extension.values.textColor[AllRound_Extension.values.weather.textColor], true);
			local dropTxtWidth = (g_currentMission.hud.gameInfoDisplay.calendarIcon.x-g_currentMission.hud.gameInfoDisplay.spacing)-posX-otherModsXdif;			
			local optiSize = g_currentMission.hlUtils.optiWidthSize(dropTxtWidth, dropTxt, AllRound_Extension.values.temporaryData.optiSize);
			setDropText(posX+(dropTxtWidth/2),color,optiSize);
		else
			AllRound_Extension.values.weather.data = {};
		end;
	end;
	if AllRound_Extension.values.weather.textIsRainInfo.isOn and g_currentMission ~= nil and g_currentMission.environment ~= nil and g_currentMission.environment.weather ~= nil then
		local env = g_currentMission.environment;
		local isRain = env.weather:getIsRaining() or env.weather:getIsHailing() or env.weather:getIsSnowing();
		local currentWeather = env.weather:getCurrentWeatherType();
		if AllRound_Extension.values.weather.textIsRainInfo.data.cW == nil then AllRound_Extension.values.weather.textIsRainInfo.data.cW = currentWeather;AllRound_Extension.values.weather.textIsRainInfo.data.setInfo = true;end;
		if isRain and AllRound_Extension.values.weather.textIsRainInfo.data.cW ~= currentWeather then AllRound_Extension.values.weather.textIsRainInfo.data.setInfo = true;AllRound_Extension.values.weather.textIsRainInfo.data.cW = currentWeather;end;
		if not isRain then AllRound_Extension.values.weather.textIsRainInfo.data.setInfo = false;end;
		if isRain and AllRound_Extension.values.weather.textIsRainInfo.data.setInfo then									
			AllRound_Extension.values.weather.textIsRainInfo.data.setInfo = false;
			local msgTxt = g_i18n:getText("ui_ingameMenuWeather").. ": ".. g_i18n:getText("warning_rainReducesYield");
			if g_currentMission.hlHudSystem.textTicker ~= nil and g_currentMission.hlHudSystem.textTicker.isOn then
				local msg = g_currentMission.hlHudSystem.textTicker:getMsgById("AllRoundExtension_RainInfo");
				if msg == nil then
					if not g_currentMission.hlHudSystem.textTicker:isCorrectTimeScale() then g_currentMission.hud:addSideNotification(FSBaseMission.INGAME_NOTIFICATION_INFO, msgTxt, 3000, GuiSoundPlayer.SOUND_SAMPLES.SUCCESS);end;
					g_currentMission.hlHudSystem.textTicker:addMsg( {text=msgTxt, color="orangeRed", id="AllRoundExtension_RainInfo"} );
				end;
			else
				g_currentMission.hud:addSideNotification(FSBaseMission.INGAME_NOTIFICATION_INFO, msgTxt, 3000, GuiSoundPlayer.SOUND_SAMPLES.SUCCESS);
			end;		
		end;		
	end;
	if old then
	if AllRound_Extension.values.weather.rainInfo and g_currentMission ~= nil and g_currentMission.environment ~= nil and g_currentMission.environment.weather ~= nil then
		if AllRound_Extension.otherMods.extendedGameInfoDisplay then otherModsXdif = g_currentMission.hud.gameInfoDisplay:scalePixelToScreenWidth(FS25_ExtendedGameInfoDisplay.ExtendedGameInfoDisplay.STRECH_GAME_INFO_DISPLAY);end;
		local isSwitchTimerTwo = g_currentMission.hlUtils.getIsSwitchTimer("allroundExtension_switchTwo");
		local weatherType = {RAIN=true,SNOW=true,HAIL=true,TWISTER=false};
		local env = g_currentMission.environment;
		local currentDay = env.currentMonotonicDay;		
		local day, dTime = env:getDayAndDayTime(env.dayTime + 21600000, env.currentMonotonicDay);
		local dayTime = env.dayTime;
		local durationTxt = "";
		function getWeatherTimeTest(current, isRain)
			if env.weather.forecastItems ~= nil then
				local difTime = 1800000; --ca. 30 min +-
				if current then
					if #env.weather.forecastItems >= 1 then
						local cW = env.weather.forecastItems[1];						
						if cW ~= nil then
							local rainDuration = cW.startDayTime+cW.duration+difTime;
							
							
							
							if day ~= currentDay then 
							
							end;
							local currentTime = 0;
							local nextDayTime = 0;
							if rainDuration > 86400000 then			
								currentTime = 86400000 - cW.startDayTime;
								nextDayTime = rainDuration - 86400000;
								rainDuration = rainDuration - 86400000; --currentDay
								if dayTime > cW.startDayTime then							
									--rainDuration = nextDayTime + currentTime;
								else
									--rainDuration = nextDayTime;  --72187479" duration="14212521
								end;
								--local dif = 86400000 - rainDuration;
								--rainDuration = rainDuration + dif;
							end;
							AllRound_Extension.testString[1] = "rainDuration".. tostring(rainDuration)
							AllRound_Extension.testString[2] = "dayTime".. tostring(dayTime)
							AllRound_Extension.testString[3] = "currentTime".. tostring(currentTime)
							AllRound_Extension.testString[4] = "nextDayTime".. tostring(nextDayTime)
							--if isRain and AllRound_Extension.values.weather.data.rainDuration ~= nil then rainDuration = AllRound_Extension.values.weather.data.rainDuration;end;
						 							
							--if dayTime > rainDuration then dayTime = dayTime - 86400000;end;
							local endRain = rainDuration-dayTime;							
							return g_currentMission.hlUtils.getMilliSecondsToHours(cW.duration+difTime, false, true, false, false, false, false), g_currentMission.hlUtils.getMilliSecondsToHours(endRain, false, true, false, false, false, false);							
						end;
					end;
				else
					if #env.weather.forecastItems >= 2 then
						local nW = env.weather.forecastItems[2];
						if nW ~= nil then
							if AllRound_Extension.values.weather.data.rainDuration == nil then 
								local rainDuration = nW.startDayTime+nW.duration+difTime;								
								AllRound_Extension.values.weather.data.rainDuration = rainDuration;							
							end;
							local nextRain = nW.startDayTime-dayTime;							
							return Utils.formatTime(nW.duration+difTime), Utils.formatTime(nextRain);
							
							--return g_currentMission.hlUtils.getMilliSecondsToHours(nW.duration+difTime, false, true, false, false, false, false), g_currentMission.hlUtils.getMilliSecondsToHours(nextRain, false, true, false, false, false, false);							
						end;
					end;
				end;
			end;
			return "", "";
		end;
		function getWeatherTime(current, isRain)
			if env.weather.forecastItems ~= nil then
				local difTime = 1800000; --ca. 30 min +-
				if current then
					if #env.weather.forecastItems >= 1 then
						local cW = env.weather.forecastItems[1];						
						local timeTotal = cW.startDayTime+cW.duration+difTime;
						if isRain and AllRound_Extension.values.weather.data.rainDuration ~= nil then timeTotal = AllRound_Extension.values.weather.data.rainDuration;end;
						if cW ~= nil then 							
							local duration = g_i18n:formatMinutes((timeTotal-dayTime)/1000/60);
							return "", duration;
							--return g_currentMission.hlUtils.getMilliSecondsToHours(cW.duration+difTime, false, true, false, false, false, false), g_currentMission.hlUtils.getMilliSecondsToHours(timeTotal-dayTime, false, true, false, false, false, false);							
						end;
					end;
				else
					if #env.weather.forecastItems >= 2 then
						local nW = env.weather.forecastItems[2];
						if nW ~= nil then
							if AllRound_Extension.values.weather.data.rainDuration == nil then AllRound_Extension.values.weather.data.rainDuration = nW.startDayTime+nW.duration+difTime;end;							
							--local nextRain = nW.startDayTime-dayTime;							
							--local test1 = g_i18n:formatMinutes((nW.duration+difTime)/1000/60);
							--local test2 = g_i18n:formatMinutes(nextRain/1000/60);
							
							local duration = Utils.formatTime((nW.duration+difTime)/1000/60);
							local nextRain = g_i18n:formatMinutes((nW.startDayTime-dayTime)/1000/60);
							
							return duration, nextRain;
							--return Utils.formatTime((nW.duration+difTime)/1000/60), Utils.formatTime(nextRain/1000/60);
							--return g_currentMission.hlUtils.getMilliSecondsToHours(nW.duration+difTime, false, true, false, false, false, false), g_currentMission.hlUtils.getMilliSecondsToHours(nextRain, false, true, false, false, false, false);							
						end;
					end;
				end;
			end;
			return "", "";
		end;
		local posX = g_currentMission.hlUtils.getOverlay(g_currentMission.hud.gameInfoDisplay.infoBgLeft) - otherModsXdif; --g_currentMission.hud.gameInfoDisplay.weatherIcon.x+(g_currentMission.hud.gameInfoDisplay.weatherIcon.width/2) + 0.001 - otherModsXdif;		
						
		local cW = env.weather:getCurrentWeatherType();
		local nW = env.weather:getNextWeatherType(day, dTime);
		local isRain = env.weather:getIsRaining() or env.weather:getIsHailing() or env.weather:getIsSnowing();
		local cW_info = weatherType[WeatherType.getName(cW)] ~= nil or isRain;
		local nW_info = nW ~= nil and weatherType[WeatherType.getName(nW)] ~= nil;
		if cW_info then				
			durationTxt, dropTxt = getWeatherTime(true, isRain);
			if dropTxt:len() > 0 then dropTxt = "~".. dropTxt;end;
		elseif nW_info then
			--posX = g_currentMission.hud.gameInfoDisplay.weatherNextIcon.x+(g_currentMission.hud.gameInfoDisplay.weatherNextIcon.width/2) - otherModsXdif;
			durationTxt, dropTxt = getWeatherTime(false);
			if dropTxt:len() > 0 and durationTxt:len() > 0 then				
				dropTxt = dropTxt.. "/~".. durationTxt;
				
				--if isSwitchTimerTwo ~= nil and isSwitchTimerTwo == 2 then dropTxt = "~".. durationTxt;end;
			end;			
		end;
		if dropTxt:len() > 0 then
			color = g_currentMission.hlUtils.getColor(AllRound_Extension.values.textColor[AllRound_Extension.values.weather.textColor], true);
			local dropTxtWidth = (g_currentMission.hud.gameInfoDisplay.calendarIcon.x-g_currentMission.hud.gameInfoDisplay.spacing)-posX-otherModsXdif;			
			local optiSize = g_currentMission.hlUtils.optiWidthSize(dropTxtWidth, dropTxt, AllRound_Extension.values.temporaryData.optiSize);
			setDropText(posX+(dropTxtWidth/2),color,optiSize);
		else
			AllRound_Extension.values.weather.data = {};
		end;		
	end;
	end;
	if AllRound_Extension.values.weather.clickFrame and not g_currentMission.hlUtils.dragDrop.on and g_currentMission.hlUtils.isMouseCursor then --not active
		local x, y, w, h = g_currentMission.hlUtils.getOverlay(g_currentMission.hud.gameInfoDisplay.infoBgLeft);
		local posY = g_currentMission.hud.gameInfoDisplay.weatherIcon.y;
		local endPosX = g_currentMission.hud.gameInfoDisplay.helpOffsetXWeather;		
		if AllRound_Extension.otherMods.extendedGameInfoDisplay then endPosX = endPosX-g_currentMission.hud.gameInfoDisplay:scalePixelToScreenWidth(FS25_ExtendedGameInfoDisplay.ExtendedGameInfoDisplay.STRECH_GAME_INFO_DISPLAY);end;
		if g_currentMission.hud.gameInfoDisplay.weatherNextIcon.visible then endPosX = endPosX+g_currentMission.hud.gameInfoDisplay.weatherNextIconOffsetX;end;
		local width = endPosX-x;
		local height = h-(posY-y);
		local inArea = g_currentMission.hlUtils.mouseIsInArea(nil, nil, x, x+width, posY, posY+height);
		if g_currentMission.hlHudSystem.infoDisplay.on and inArea then 
			g_currentMission.hlHudSystem:addTextDisplay( {txt=g_i18n:getText("box_weather_clickFrame_help")} );
			g_currentMission.hlHudSystem:addMouseAcceptsInfo( {acceptsMouse={"left"}} );
		end;
		if not g_currentMission.hlUtils:disableInArea() and inArea then g_currentMission.hlHudSystem:setClickArea( {x, x+width, posY, posY+height, onClick=AllRound_Extension_MouseKeyEvents.onClickArea, whatClick="AllRound_Extension_OtherAreas", whereClick="weatherFrame_", ownTable={}} );end;
	end;	
end;

function AllRound_ExtensionSetGet:loadSaleSystem()
	VehicleSaleSystem.addSale = Utils.appendedFunction(VehicleSaleSystem.addSale, AllRound_ExtensionSetGet.setSaleSystem);	
end;

function AllRound_ExtensionSetGet:removeSaleMsgOrOverlay(isMsg, onlyMsg)
	if g_currentMission.hlHudSystem.textTicker ~= nil and g_currentMission.hlHudSystem.textTicker.isOn then
		local msg = isMsg or g_currentMission.hlHudSystem.textTicker:getMsgById("AllRoundExtension_VehicleSaleInfo");
		if msg ~= nil then
			g_currentMission.hlHudSystem.textTicker:removeMsgById(msg.id);
		end;
	end;
	if onlyMsg == nil or not onlyMsg then AllRound_Extension.values.vehicleSaleSystem.setOverlay = false;end;
end;

function AllRound_ExtensionSetGet:generateSaleOverlay()
	AllRound_Extension.values.vehicleSaleSystem.generateOverlay = true;
	local guiBox = AllRound_Extension.values.guiMenu;
	local textHeight = getTextHeight(g_currentMission.hud.gameInfoDisplay.moneyTextSize, tostring("99"));
	local height = g_currentMission.hud.gameInfoDisplay.y-(g_currentMission.hud.gameInfoDisplay.moneyBgScale.y)-(g_currentMission.hud.gameInfoDisplay.moneyTextOffsetY)-textHeight;
	local iconWidth, iconHeight = g_currentMission.hlUtils.getOptiIconWidthHeight(height, guiBox.screen.pixelW, guiBox.screen.pixelH);
	local x = g_currentMission.hud.gameInfoDisplay.helpOffsetXMoney+(g_currentMission.hud.gameInfoDisplay.moneyBgRight.width/2)-(iconWidth/2);
	local y = g_currentMission.hud.gameInfoDisplay.y-iconHeight-guiBox.screen.difHeight;
	local overlayDefaultGroup = guiBox.overlays["defaultIcons"]["guiBox"];
	local overlayDefaultByName = guiBox.overlays.byName["defaultIcons"]["guiBox"];
	local overlay = overlayDefaultGroup[overlayDefaultByName["saleItemBW"]];
	g_currentMission.hlUtils.setOverlay(overlay, x, y, iconWidth, iconHeight);
	overlay = overlayDefaultGroup[overlayDefaultByName["saleItemColor"]];
	g_currentMission.hlUtils.setOverlay(overlay, x, y, iconWidth, iconHeight);
end;

function AllRound_ExtensionSetGet.setSaleSystem(self)
	if not self.isEnabled then return;end;
	if AllRound_Extension.values.vehicleSaleSystem.isOn then		
		AllRound_Extension.values.vehicleSaleSystem.setOverlay = true;
		if AllRound_Extension.values.vehicleSaleSystem.setInfo then
			local msgTxt = g_i18n:getText("category_sales").. ": ".. g_i18n:getText("finance_newVehiclesCost");
			if g_currentMission.hlHudSystem.textTicker ~= nil and g_currentMission.hlHudSystem.textTicker.isOn then
				local msg = g_currentMission.hlHudSystem.textTicker:getMsgById("AllRoundExtension_VehicleSaleInfo");
				if msg == nil then						
					if not g_currentMission.hlHudSystem.textTicker:isCorrectTimeScale() then g_currentMission.hud:addSideNotification(FSBaseMission.INGAME_NOTIFICATION_INFO, msgTxt, 3000, GuiSoundPlayer.SOUND_SAMPLES.SUCCESS);end;
					g_currentMission.hlHudSystem.textTicker:addMsg( {text=msgTxt, color="yellow", id="AllRoundExtension_VehicleSaleInfo", repeatable=1, repeatableWait=700} );
				end;									
			else
				--g_gui.guiSoundPlayer:playSample(GuiSoundPlayer.SOUND_SAMPLES.ACHIEVEMENT);
				g_currentMission.hud:addSideNotification(FSBaseMission.INGAME_NOTIFICATION_INFO, msgTxt, 3000, GuiSoundPlayer.SOUND_SAMPLES.SUCCESS);
			end;
		else
			g_gui.guiSoundPlayer:playSample(GuiSoundPlayer.SOUND_SAMPLES.SUCCESS);
		end;	
	end;
end;

function AllRound_ExtensionSetGet.setSaleSystemSaved(self)
	if not self.isEnabled then return;end;
	function reset()
		AllRound_Extension.values.vehicleSaleSystem.items = {};
		AllRound_Extension.values.vehicleSaleSystem.lastState = g_currentMission.vehicleSaleSystem.numGeneratedItems;
	end;
	function setSaleItems()
		for s=1, g_currentMission.vehicleSaleSystem.numGeneratedItems do
			local saleItem = g_currentMission.vehicleSaleSystem:getSaleById(s);
			if saleItem ~= nil then table.insert(AllRound_Extension.values.vehicleSaleSystem.items, saleItem);end;
		end;	
	end;
	function isAlReadyExists(saleItem)
		if AllRound_Extension.values.vehicleSaleSystem.lastState == 0 then return false;end;
		for k,v in pairs(AllRound_Extension.values.vehicleSaleSystem.items) do
			if v == saleItem then return true;end;
		end;
		return false;
	end;
	if AllRound_Extension.values.vehicleSaleSystem.isOn and g_currentMission.vehicleSaleSystem ~= nil then
		if AllRound_Extension.values.vehicleSaleSystem.firstStart then
			if g_currentMission.vehicleSaleSystem.numGeneratedItems > 0 then
				setSaleItems();
				AllRound_Extension.values.vehicleSaleSystem.lastState = g_currentMission.vehicleSaleSystem.numGeneratedItems;
			end;
			AllRound_Extension.values.vehicleSaleSystem.firstStart = false;
		else
			local alReadyExists = true;			
			for s=1, g_currentMission.vehicleSaleSystem.numGeneratedItems do
				local saleItem = g_currentMission.vehicleSaleSystem:getSaleById(s);
				if saleItem ~= nil then 
					if not isAlReadyExists(saleItem) then alReadyExists = false;break;end;
				end;
			end;			
			if not alReadyExists then 
				
			end; 
			reset();
			setSaleItems();
		end;
	else
		reset();
	end;
end;

function AllRound_ExtensionSetGet:setPlayerSuperSpeed(on)
	local player = g_localPlayer;
	if player ~= nil and player.toggleSuperSpeedCommand ~= nil then
		if player.isOwner then									
			if on ~= nil and on then
				player.toggleSuperSpeedCommand.value = true;				
			else
				player.toggleSuperSpeedCommand.value = not player.toggleSuperSpeedCommand.value;
				AllRound_Extension.values.superSpeed = player.toggleSuperSpeedCommand.value;
			end;
		end;								
		if not player.toggleSuperSpeedCommand.value then AllRound_Extension.values.superSpeed = false;PlayerStateWalk.MAXIMUM_RUN_SPEED = 7;else PlayerStateWalk.MAXIMUM_RUN_SPEED = AllRound_Extension.values.superSpeedMover[1];end;
	end;
end;

function AllRound_ExtensionSetGet:setPlayerSuperStrength(on)
	local player = g_localPlayer;	
	if player ~= nil and player.hands ~= nil and player.hands.consoleCommandToggleSuperStrength ~= nil then
		if AllRound_Extension.values.handTool.defaultMaxMass == 0 then AllRound_Extension.values.handTool.defaultMaxMass = g_localPlayer.maximumHandToolCarryMass;end;
		if player.isOwner then			
			if g_currentMission.missionDynamicInfo.isMultiplayer then
				local mpPlayer = g_currentMission.playerSystem:getPlayerByUserId(g_currentMission.playerUserId);			
				if mpPlayer ~= nil and mpPlayer.uniqueUserId ~= nil then
					local playerUniqueId = mpPlayer.uniqueUserId;
					if on ~= nil and on then
						player.hands:consoleCommandToggleSuperStrength();
						player.hands.spec_hands.hasSuperStrength = true;
						AllRound_Extension.values.superStrength = true;
						if g_server ~= nil then							
							g_server:broadcastEvent(AllRound_ExtensionSetGetEvent.new(AllRound_Extension.values.superStrength, playerUniqueId));
						else							
							g_client:getServerConnection():sendEvent(AllRound_ExtensionSetGetEvent.new(AllRound_Extension.values.superStrength, playerUniqueId));
						end;												
					else						
						if g_server ~= nil then
							player.hands:consoleCommandToggleSuperStrength();
							AllRound_Extension.values.superStrength = player.hands.spec_hands.hasSuperStrength;
							g_server:broadcastEvent(AllRound_ExtensionSetGetEvent.new(AllRound_Extension.values.superStrength, playerUniqueId));
						else
							player.hands:consoleCommandToggleSuperStrength();
							AllRound_Extension.values.superStrength = player.hands.spec_hands.hasSuperStrength;
							g_client:getServerConnection():sendEvent(AllRound_ExtensionSetGetEvent.new(AllRound_Extension.values.superStrength, playerUniqueId));
						end;
					end;
				end;
			else					
				if on ~= nil and on then
					player.hands:consoleCommandToggleSuperStrength();
					player.hands.spec_hands.hasSuperStrength = true;
					AllRound_Extension.values.superStrength = true;					
				else						
					player.hands:consoleCommandToggleSuperStrength(); 
					AllRound_Extension.values.superStrength = player.hands.spec_hands.hasSuperStrength;				
				end;					
			end;						
		end;								
		if not player.hands.spec_hands.hasSuperStrength then AllRound_Extension.values.superStrength = false;end;									
	end;
end;

function AllRound_ExtensionSetGet:setMouseCursorMarker(color)
	local guiBox = AllRound_Extension.values.guiMenu;
	local overlayDefaultGroup = guiBox.overlays["defaultIcons"]["guiBox"];
	local overlayDefaultByName = guiBox.overlays.byName["defaultIcons"]["guiBox"];
	local overlay = overlayDefaultGroup[overlayDefaultByName["mouseCursorMarker"]];
	if color ~= nil and color then
		local color = AllRound_Extension.values.textColor[AllRound_Extension.values.mouseCursorMarker.color];
		g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(color, true));
	else
		local iconWidth, iconHeight = g_currentMission.hlUtils.getOptiIconWidthHeight(AllRound_Extension.values.mouseCursorMarker.size[1]/1000, guiBox.screen.pixelW, guiBox.screen.pixelH);
		local difY = (AllRound_Extension.values.mouseCursorMarker.size[1]/1000)-0.010;
		local difX = 0.0005;
		g_currentMission.hlUtils.setOverlay(overlay, g_currentMission.hlUtils.mouseCursor.posX-difX, g_currentMission.hlUtils.mouseCursor.posY-(iconHeight*2)+(difY), iconWidth, iconHeight);
	end;
end;

function AllRound_ExtensionSetGet:renderMouseCursorMarker(guiBox)
	if g_currentMission.hlHudSystem.isInClickArea == nil or g_currentMission.hlHudSystem.isInClickArea or g_currentMission.hlUtils.dragDrop.on then return;end;
	local overlayDefaultGroup = guiBox.overlays["defaultIcons"]["guiBox"];
	local overlayDefaultByName = guiBox.overlays.byName["defaultIcons"]["guiBox"];
	local overlay = overlayDefaultGroup[overlayDefaultByName["mouseCursorMarker"]];	
	overlay:render();
end;
------------------------------
