AllRound_ExtensionGuiBoxSetGet = {};

function AllRound_ExtensionGuiBoxSetGet:loadIcons(guiBox) 
	if guiBox.overlays == nil then guiBox.overlays = {byName={}};end;
	local firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="are_display.other1Icons32", modDir=AllRound_Extension.modDir, iconFile="hlHudSystem/icons/other1Icons.dds", xmlFile="icons_are/icons.xml", modName="defaultIcons", groupName="guiBox", fileFormat={32,256,512}, iconTable=guiBox.overlays} );
	firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="are_display.colorIcons32", modDir=AllRound_Extension.modDir, iconFile="hlHudSystem/icons/colorIcons.dds", xmlFile="icons_are/icons.xml", modName="defaultIcons", groupName="guiBox", fileFormat={32,128,256}, iconTable=guiBox.overlays} );
	firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="are_display.icons", modDir=AllRound_Extension.modDir, iconFile="hlHudSystem/icons/icons.dds", xmlFile="icons_are/icons.xml", modName="defaultIcons", groupName="guiBox", fileFormat={64,512,1024}, iconTable=guiBox.overlays} );
	
end;

function AllRound_ExtensionGuiBoxSetGet.getLines(args)	
	local guiBox = args.guiBox;
	if guiBox == nil then return;end;	
	local line = args.line or 1;
	local overlayDefaultGroup = guiBox.overlays["defaultIcons"]["guiBox"];
	local overlayDefaultByName = guiBox.overlays.byName["defaultIcons"]["guiBox"];
	local values = AllRound_Extension.values;
	local textL = "";
	local textR = "-";
	local textColor = "white";
	local textOffColor = g_currentMission.hlHudSystem.overlays.color.notActive;
	local iconColor = g_currentMission.hlHudSystem.overlays.color.notActive;	
	local onColor = g_currentMission.hlHudSystem.overlays.color.on;
	local languageColorTxt = g_i18n:getText("configuration_valueColor");
	local helpText = "";
	local helpText2 = "";	
	local stateOn = g_i18n:getText("ui_on");
	local stateOff = g_i18n:getText("ui_off");
	local state = false;
	local stateColor = nil;	
	local moreTxt = "";
	local infoTxt = "";
		
	---miniMap---	
	if guiBox.guiLines[line] == "miniMapHeadline_" then	
		textL = g_i18n:getText("box_title_minimap");	
		return {typ="headline", helpText=g_i18n:getText("box_help_minimap"), text={[1]={text=textL, color="ls25"}} };
	end;
	if guiBox.guiLines[line] == "miniMapEmpty_" then	
		textL = g_i18n:getText("box_empty_minimap");
		if values.miniMapState[1] then iconColor = onColor;else stateColor = textOffColor;end;
		return {oneClick=true, typ="boolean", text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.miniMapState[1]}}, ownTable={1} };
	end;
	if guiBox.guiLines[line] == "miniMapRound_" then	
		textL = g_i18n:getText("box_round_minimap");
		if values.miniMapState[2] then iconColor = onColor;else stateColor = textOffColor;end;
		return {oneClick=true, typ="boolean", text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.miniMapState[2]}}, ownTable={2} };
	end;
	if guiBox.guiLines[line] == "miniMapQuadrat_" then	
		textL = g_i18n:getText("box_quadrat_minimap");
		if values.miniMapState[3] then iconColor = onColor;else stateColor = textOffColor;end;
		return {oneClick=true, typ="boolean", text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.miniMapState[3]}}, ownTable={3} };
	end;
	---miniMap---
	---weather---
	if guiBox.guiLines[line] == "weatherHeadline_" then	
		textL = g_i18n:getText("box_title_weather");	
		return {typ="headline", helpText=g_i18n:getText("box_help_all"), text={[1]={text=textL, color="ls25"}} };
	end;
	if guiBox.guiLines[line] == "weatherClickFrame_" then	
		textL = g_i18n:getText("box_weather_clickFrame");
		if values.weather.clickFrame then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("box_weather_clickFrame_help");
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.weather.clickFrame}}, ownTable={"clickFrame"} };
	end;
	if guiBox.guiLines[line] == "weatherRainInfo_" then	
		textL = g_i18n:getText("box_weather_rainInfo");
		if values.weather.rainInfo then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("box_weather_rainInfo_help");
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.weather.rainInfo}}, ownTable={"rainInfo"} };
	end;
	if guiBox.guiLines[line] == "weatherRainInfoColor_" then	
		textL = g_i18n:getText("box_colorText");
		state = true;
		if values.weather.textColor and values.weather.rainInfo then iconColor = onColor;else stateColor = textOffColor;state = false;end;
		local colorText = tostring(AllRound_Extension.values.textColor[values.weather.textColor]:upper())
		helpText = g_i18n:getText("ui_weatherForecast").. " (Text-".. languageColorTxt.. " ".. tostring(colorText).. ")";
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}}, ownTable={"textColor"} };
	end;
	if guiBox.guiLines[line] == "weatherTextIsRainInfo_" then	
		textL = g_i18n:getText("box_weather_textIsRainInfo");
		if values.weather.textIsRainInfo.isOn then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("box_weather_textIsRainInfo_help");
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.weather.textIsRainInfo.isOn}}, ownTable={"weatherTextIsRainInfo"} };
	end;
	---weather---
	---temperatur---
	local temperaturUnit = "unit_celsius";
	if g_i18n.useFahrenheit then temperaturUnit = "unit_fahrenheit";end;
	if guiBox.guiLines[line] == "temperaturHeadline_" then	
		textL = g_i18n:getText("box_title_temperatur");	
		return {typ="headline", helpText=g_i18n:getText("box_help_all"), text={[1]={text=textL, color="ls25"}} };
	end;
	if guiBox.guiLines[line] == "temperaturIcon_" then	
		textL = g_i18n:getText("box_onoff_temperatur");
		if values.temperatur.icon then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText(temperaturUnit).. " (Icon)";
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.temperatur.icon}}, ownTable={"icon"} };
	end;
	if guiBox.guiLines[line] == "temperaturIconColor_" then	
		textL = g_i18n:getText("box_colorIcon_temperatur");
		if values.temperatur.iconColor then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText(temperaturUnit).. " (Icon-".. languageColorTxt.. ")";
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.temperatur.iconColor}}, ownTable={"iconColor"} };
	end;
	if guiBox.guiLines[line] == "currentTemperatur_" then	
		textL = g_i18n:getText("box_currentText_temperatur");
		if values.temperatur.current then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText(temperaturUnit).. " (".. g_i18n:getText("ui_currently").. ")";
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.temperatur.current}}, ownTable={"current"} };
	end;
	if guiBox.guiLines[line] == "currentTemperaturColor_" then	
		textL = g_i18n:getText("box_colorText_temperatur");
		if values.temperatur.currentColor then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText(temperaturUnit).. " (".. g_i18n:getText("ui_currently").. "-".. languageColorTxt.. ")";
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.temperatur.currentColor}}, ownTable={"currentColor"} };
	end;
	---temperatur---
	---season---
	if guiBox.guiLines[line] == "seasonIngameTimeHeadline_" then	
		textL = g_i18n:getText("box_title_seasonIngameTime");	
		return {typ="headline", helpText=g_i18n:getText("box_help_all"), text={[1]={text=textL, color="ls25"}} };
	end;
	if guiBox.guiLines[line] == "yearsPlayed_" then	
		textL = g_i18n:getText("box_yearsPlayed_season");
		if values.season.yearsPlayed then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("statistic_yearsPlayed");
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.season.yearsPlayed}}, ownTable={"yearsPlayed"} };
	end;
	if guiBox.guiLines[line] == "yearsPlayedColor_" then	
		textL = g_i18n:getText("box_colorText");
		state = true;
		if values.season.textColor and (values.season.yearsPlayed or values.ingameTime.playDays) then iconColor = onColor;else stateColor = textOffColor;state = false;end;
		local colorText = tostring(AllRound_Extension.values.textColor[values.season.textColor]:upper())
		helpText = g_i18n:getText("statistic_yearsPlayed").." | ".. g_i18n:getText("statistic_playTime").. " (Text-".. languageColorTxt.. " ".. tostring(colorText).. ")";
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}}, ownTable={"textColor"} };
	end;
	---season---
	---ingameTime---
	--if guiBox.guiLines[line] == "ingameTimeHeadline_" then	
	--	textL = g_i18n:getText("box_title_ingameTime");	
	--	return {typ="headline", helpText=g_i18n:getText("box_help_all"), text={[1]={text=textL, color="ls25"}} };
	--end;
	if guiBox.guiLines[line] == "ingameTimeClickFrame_" then
		textL = g_i18n:getText("box_ingameTime_clickFrame");
		if values.ingameTime.clickFrame then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("box_ingameTime_clickFrame_help");
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.ingameTime.clickFrame}}, ownTable={"clickFrame"} };	
	end;
	if guiBox.guiLines[line] == "defaultTimeScale_" then
		textL = g_i18n:getText("box_ingameTime_defaultTimeScale");
		helpText = g_i18n:getText("box_ingameTime_defaultTimeScale_help");
		if values.ingameTime.clickFrame then 
			local scaleTime = Platform.gameplay.timeScaleSettings[AllRound_Extension.values.ingameTime.defaultTimeScale];
			if scaleTime == nil then scaleTime = Platform.gameplay.defaultTimeScale;end;
			iconColor = onColor;
			state = true;
			return {typ="number", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={state=state,text=tostring(scaleTime)}} }; 
		else 
			stateColor = textOffColor;
			state = false;
			iconColor = textOffColor;
			return {oneClick=true, iconColor=iconColor, typ="string", helpText=helpText, text={[1]={text=textL,color=stateColor}} };
		end;
	end;
	if guiBox.guiLines[line] == "timeScaleColor_" then	
		textL = g_i18n:getText("box_scaleIcon_ingameTime");
		if values.ingameTime.timeScaleColor then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("setting_timeScale").. " (Icon-".. languageColorTxt.. ")";
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.ingameTime.timeScaleColor}}, ownTable={"timeScaleColor"} };
	end;
	if guiBox.guiLines[line] == "ingamePlayDays_" then	
		textL = g_i18n:getText("box_playDays_ingameTime");
		if values.ingameTime.playDays then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("statistic_playTime").. " (".. g_i18n:getText("ui_days").. ")";
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.ingameTime.playDays}}, ownTable={"playDays"} };
	end;	
	---ingameTime---
	---realDayTime---
	if guiBox.guiLines[line] == "realDayTimeHeadline_" then	
		textL = g_i18n:getText("box_title_realDayTime");	
		return {typ="headline", helpText=g_i18n:getText("box_help_all"), text={[1]={text=textL, color="ls25"}} };
	end;
	if guiBox.guiLines[line] == "realDayTime_" then	
		textL = g_i18n:getText("box_dayTime_realDayTime");
		if values.realDayTime.dayTime then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("ui_day").. "/".. g_i18n:getText("ui_realTime");
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.realDayTime.dayTime}}, ownTable={"dayTime"} };
	end;
	if guiBox.guiLines[line] == "realDayLarge_" then	
		textL = g_i18n:getText("box_dayLarge_realDayTime");
		if values.realDayTime.dayLarge then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_currentMission.hlUtils.getRealDayString(false).. "/".. g_currentMission.hlUtils.getRealDayString(true);
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.realDayTime.dayLarge}}, ownTable={"dayLarge"} };
	end;
	if guiBox.guiLines[line] == "realFormat12_" then	
		textL = g_i18n:getText("box_pm_realDayTime");
		if values.realDayTime.format12 then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("ui_realTime").. " (12/24)";
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.realDayTime.format12}}, ownTable={"format12"} };
	end;
	if guiBox.guiLines[line] == "realDate_" then	
		textL = g_i18n:getText("box_date_realDayTime");
		if values.realDayTime.date then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("box_date_realDayTime");
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.realDayTime.date}}, ownTable={"date"} };
	end;
	if guiBox.guiLines[line] == "realTextColor_" then	
		textL = g_i18n:getText("box_colorText");
		state = true;
		if values.realDayTime.textColor and (values.realDayTime.date or values.realDayTime.dayTime) then iconColor = onColor;else stateColor = textOffColor;state = false;end;
		local colorText = tostring(AllRound_Extension.values.textColor[values.realDayTime.textColor]:upper())
		helpText = g_i18n:getText("ui_realTime").. " (Text-".. languageColorTxt.. " ".. tostring(colorText).. ")";
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}}, ownTable={"textColor"} };
	end;	
	---realDayTime---
	---otherSettings---
	if guiBox.guiLines[line] == "otherSettingsHeadline_" then	
		textL = g_i18n:getText("box_title_otherSettings");	
		return {typ="headline", helpText=g_i18n:getText("box_help_all"), text={[1]={text=textL, color="ls25"}} };
	end;
	if guiBox.guiLines[line] == "vehicleSaleInfo_" then	
		textL = g_i18n:getText("category_sales").. "/".. g_i18n:getText("ui_inGameMenuBriefing");
		state = AllRound_Extension.values.vehicleSaleSystem.isOn;
		if state then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("ui_information").. ": ".. g_i18n:getText("category_sales").. "/".. g_i18n:getText("finance_newVehiclesCost").. " visual in Money Hud";
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };
	end;
	if guiBox.guiLines[line] == "vehicleSaleTextInfo_" then	
		textL = g_i18n:getText("box_vehicleSaleTextInfo");
		state = AllRound_Extension.values.vehicleSaleSystem.isOn and AllRound_Extension.values.vehicleSaleSystem.setInfo;
		if state then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("box_help_vehicleSaleTextInfo");		
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };		
	end;
	if guiBox.guiLines[line] == "superSpeed_" then	
		textL = g_i18n:getText("box_title_superSpeed");
		local isActive = g_localPlayer ~= nil and g_localPlayer.toggleSuperSpeedCommand ~= nil and g_localPlayer.toggleSuperSpeedCommand;
		state = AllRound_Extension.values.superSpeed and isActive;
		if state then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("box_help_superSpeed");		
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };
	end;
	if guiBox.guiLines[line] == "superSpeedMover_" then
		textL = g_i18n:getText("ui_hudSpeedGaugeSpeed");		
		helpText = g_i18n:getText("action_changeSpeed");
		if AllRound_Extension.values.superSpeed then
			state = true;
			iconColor = onColor;
			return {typ="number", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={state=state,text=tostring(AllRound_Extension.values.superSpeedMover[1])}} };
		else
			state = false;
			stateColor = textOffColor;
			iconColor = textOffColor;
			return {oneClick=true, iconColor=iconColor, typ="string", helpText=helpText, text={[1]={text=textL,color=stateColor}} };
		end;		
	end;
	if guiBox.guiLines[line] == "superStrength_" then	
		textL = g_i18n:getText("box_title_superStrength");
		local isActive = g_localPlayer ~= nil and g_localPlayer.hands ~= nil and g_localPlayer.hands.spec_hands ~= nil and g_localPlayer.hands.spec_hands.hasSuperStrength;		
		state = AllRound_Extension.values.superStrength and isActive;
		if state then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("box_help_superStrength");		
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };
	end;
	if guiBox.guiLines[line] == "flightMode_" then	
		textL = g_i18n:getText("box_title_flightMode");
		local isActive = g_localPlayer ~= nil and g_localPlayer.toggleFlightModeCommand ~= nil and g_localPlayer.toggleFlightModeCommand.value;
		state = AllRound_Extension.values.flightMode and isActive;
		if state then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("box_help_flightMode");		
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };
	end;
	if guiBox.guiLines[line] == "hudsVisible_" then	
		textL = g_i18n:getText("box_title_hudsVisible");
		state = AllRound_Extension.values.hudsVisible and g_currentMission.hlHudSystem:getHudIsVisible();
		if state then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("box_help_hudvisible");		
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };
	end;
	if guiBox.guiLines[line] == "handToolSwitch_" then	
		textL = g_i18n:getText("box_title_handtool");
		if AllRound_Extension.values.handTool.switch then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("box_help_handtool");		
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["handTool"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=AllRound_Extension.values.handTool.switch}} };
	end;
	if guiBox.guiLines[line] == "mouseCursorMarkerIsOn_" then
		textL = g_i18n:getText("box_title_mouseCursorMarkerIsOn");
		if AllRound_Extension.values.mouseCursorMarker.isOn then iconColor = onColor;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("box_help_mouseCursorMarkerIsOn");
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=AllRound_Extension.values.mouseCursorMarker.isOn}} };
	end;
	if guiBox.guiLines[line] == "mouseCursorMarkerSize_" then
		textL = g_i18n:getText("box_title_mouseCursorMarkerSize");		
		helpText = g_i18n:getText("box_help_mouseCursorMarkerSize");
		if AllRound_Extension.values.mouseCursorMarker.isOn then
			state = true;
			iconColor = onColor;
			return {typ="number", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={state=state,text=tostring(AllRound_Extension.values.mouseCursorMarker.size[1]/1000)}} };
		else
			state = false;
			stateColor = textOffColor;
			iconColor = textOffColor;
			return {oneClick=true, iconColor=iconColor, typ="string", helpText=helpText, text={[1]={text=textL,color=stateColor}} };
		end;
	end;
	if guiBox.guiLines[line] == "mouseCursorMarkerColor_" then
		textL = g_i18n:getText("box_title_mouseCursorMarkerColor");		
		helpText = g_i18n:getText("box_help_mouseCursorMarkerColor");
		if AllRound_Extension.values.mouseCursorMarker.isOn then
			state = true;
			iconColor = onColor;
			local colorText = tostring(AllRound_Extension.values.textColor[values.mouseCursorMarker.color]:upper());
			helpText = helpText.. " (Icon-".. languageColorTxt.. " ".. tostring(colorText).. ")";
			return {typ="number", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={state=state,text=tostring(AllRound_Extension.values.mouseCursorMarker.color)}} };
		else
			state = false;
			stateColor = textOffColor;
			iconColor = textOffColor;
			return {oneClick=true, iconColor=iconColor, typ="string", helpText=helpText, text={[1]={text=textL,color=stateColor}} };
		end;
	end;
	---otherSettings---
	---other view---
	if guiBox.guiLines[line] == "otherHeadline_" then	
		textL = g_i18n:getText("box_title_other");	
		return {typ="headline", helpText=g_i18n:getText("box_help_all"), text={[1]={text=textL, color="ls25"}} };
	end;
	if guiBox.guiLines[line] == "adShowMarkersOnMinimap_" then	
		textL = g_i18n:getText("box_title_ad_showMarkersOnMinimap");
		state = true;
		if values.ad.showMarkersOnMinimap then iconColor = onColor;else stateColor = textOffColor;state = false;end;		
		if not AllRound_Extension.otherMods.autoDrive or not AllRound_Extension.values.ad.getMod.AutoDrive.getSettingState("showMarkersOnMap") then stateColor = textOffColor;state = false;end;
		helpText = g_i18n:getText("box_ad_showMarkersOnMinimap");
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };
	end;
	local textTicker = g_currentMission.hlHudSystem.textTicker;
	if guiBox.guiLines[line] == "sayings_" then
		textL = g_i18n:getText("box_textTicker_sayings");
		local stateText = stateOff;
		helpText = string.format(g_i18n:getText("box_textTicker_help_sayings"), #AllRound_Extension.sayings.randomTexts);
		local language = g_languageShort;
		if AllRound_Extension.sayings.acceptsLanguage[g_languageShort] == nil then language = "DE";end; 
		helpText = helpText.. "\n".. g_i18n:getText("ui_inGameMenuBriefing").. ": ".. g_i18n:getText("ui_language").. " ".. tostring(language:upper());		
		if AllRound_Extension.values.sayings.on[1] > 1 then stateText = stateOn;state = true;iconColor = onColor;else stateColor = textOffColor;end;
		if not textTicker.isOn then			
			helpText = g_i18n:getText("box_textTicker_help_needs");
			iconColor = textOffColor;
			stateColor = textOffColor;
			return {icon=overlayDefaultGroup[overlayDefaultByName["sayings"]], helpText=helpText, iconColor=iconColor, typ="string", text={[1]={text=textL,color=stateColor}} };
		else	
			return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["sayings"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}} };
		end;
	end;
	if guiBox.guiLines[line] == "sayingsTimer_" then
		textL = g_i18n:getText("box_textTicker_sayingsTimer");
		local stateText = stateOff;
		helpText = string.format(g_i18n:getText("box_textTicker_help_sayingsTimer"), AllRound_Extension.values.sayings.timer[1]);
		if AllRound_Extension.values.sayings.on[1] > 1 then stateText = stateOn;state = true;iconColor = onColor;else stateColor = textOffColor;end;
		if not textTicker.isOn or AllRound_Extension.values.sayings.on[1] == 1 then			
			iconColor = textOffColor;
			stateColor = textOffColor;
			return {iconColor=iconColor, typ="string", text={[1]={text=textL,color=stateColor}} };
		else
			return {iconColor=iconColor, typ="number", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={text=tostring(AllRound_Extension.values.sayings.timer[1])}} };
		end;		
	end;
	---other view---	
end;