AllRound_Extension = {};
AllRound_Extension.modDir = g_currentModDirectory;
AllRound_Extension.modName = g_currentModName;
source(AllRound_Extension.modDir.."scripte_are/AllRound_ExtensionSetGetEvent.lua");

AllRound_Extension.metadata = {
	interface = "FS25 ...", --convert ls22 to ls25
	title = "AllRound Extension",
	notes = "Zeigt/Ändert Werte und Anzeige Optionen (mit integrierten HL Hud System)",
	author = "(by HappyLooser)",	
	version = "1.0.0.1",
	build = 28,
	xmlVersion = 1,
	languageVersion = 1,
	datum = "06.04.2024", 
	update = "22.06.2025",
	discord = "HappyLooser Modding",	
	info = "Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt"	
};

function AllRound_Extension:loadMap(mapName)		
	print("---loading ".. tostring(AllRound_Extension.metadata.title).. " ".. tostring(AllRound_Extension.metadata.version).. "(#".. tostring(AllRound_Extension.metadata.build).. ") ".. tostring(AllRound_Extension.metadata.author).. "---")
	if not AllRound_Extension:getDetiServer() then
		AllRound_Extension:loadValues();
	end;
	AllRound_Extension:replaceSystem();
	AllRound_Extension:replaceHandTool();
end;

function AllRound_Extension:loadValues() --for All in Mod Extra Load
	if not AllRound_Extension:getDetiServer() then
		AllRound_Extension.hlDebugMode = false;	--for Modder Testing	
		AllRound_Extension.testString = {};		
		generateFolders();		
		AllRound_Extension.otherMods = {autoDrive=false,extendedGameInfoDisplay=false,realisticWeather=false};
		AllRound_Extension:searchOtherMods();
		AllRound_Extension:loadSource(1);		
		AllRound_Extension.loadError = false; --optional for !
		AllRound_Extension:registerActionEvent();
		Mission00.onStartMission = Utils.appendedFunction(Mission00.onStartMission, AllRound_Extension.onStartMission);		
	end;
end;

function AllRound_Extension:onStartMission()
	if AllRound_Extension:getDetiServer() then return;end;	
	if g_currentMission.hlHudSystem ~= nil and g_currentMission.hlHudSystem.hlHud ~= nil and g_currentMission.hlHudSystem.hlHud.generate ~= nil then --check is HL Hud System ready !
		g_currentMission.hlUtils.modLoad("FS25_AllRoundExtension");	
		print("#Info: ".. tostring(AllRound_Extension.metadata.title).. " generate GuiBox --> for HL Hud System (".. tostring(g_currentMission.hlHudSystem.metadata.version).. ")")
		AllRound_Extension.values = {ad={showMarkersOnMinimap=true},handTool={defaultMaxMass=0,maxMass=10000,switch=true},mouseCursorMarker={isOn=false,size={12,10,20,1},color=13},miniMapState={true,true,true,true,false},temporaryData={},temperatur={icon=false,text=true,current=false,iconColor=false,currentColor=false,data={}},ingameTime={clickFrame=false,defaultTimeScale=1,textColor=1,timeScaleColor=false,playDays=false,data={}},realDayTime={dayTime=false,dayLarge=false,date=false,format12=false,textColor=1,data={}},weather={textColor=12,rainInfo=false,textIsRainInfo={isOn=false,data={setInfo=false}},clickFrame=false,data={}},season={textColor=1,yearsPlayed=false,data={}},handToolSpeed={2,1,2,1,1.1};superSpeed=false,superSpeedMover={6,1,6,1},superStrength=false,superStrengthOnLoad=false,flightMode=false,hudsVisible=true,textColor={"ls25","ls25active","ls22","ls15","green","orange","lightGreen","mangenta","gold","khaki","royalBlue","yellow","orangeRed"},vehicleSaleSystem={isOn=false,setInfo=false,timer=0,generateOverlay=false,setOverlay=false}};			
		if AllRound_Extension.otherMods.autoDrive then AllRound_Extension.values.ad.getMod = _G["FS25_AutoDrive"];end;
		g_currentMission.hlUtils.globalFunction["FS25_AllRoundExtension"] = {
			getHandTool=function()return AllRound_Extension.values.handTool.switch;end;
			loadSayingsXmlTexts=function(xmlFilem, playerName) AllRound_ExtensionSayings:loadXmlTexts(xmlFile, playerName);end;
		};
		--AllRound_ExtensionSetGet:loadGameInfoDisplay();
		AllRound_Extension:loadSource(2);
		
		AllRound_Extension.values.sayings = {
			on = {1,1,2};
			timer = {60,15,120,5,60}; --is,min,max,level,default (~ min)
			joke = {1,1,2};
			jokeRandom = {40,10,100,5,40}; 
			jokeTimer = {45,25,50,5,45}; --default (~ min)			
		};
			
		AllRound_Extension_XmlGuiBox:loadGuiBox("AllRound_Extension_GuiBox");		
		if g_currentMission.hlHudSystem.hlGuiBox:getData("AllRound_Extension_GuiBox") ~= nil then			
			g_currentMission.hlUtils.loadLanguage( {modTitle=tostring(AllRound_Extension.metadata.title), class=AllRound_Extension.modName, modDir=AllRound_Extension.modDir.. "scripte_are/", xmlDir="FS25_AllRoundExtension", xmlVersion=AllRound_Extension.metadata.languageVersion} );
			g_currentMission.hlUtils.addSwitchTimer( {name="allroundExtension_switchTwo", delay=10, switch={[1]=30,[2]=3}} );
			AllRound_ExtensionSetGet:loadSaleSystem();
			AllRound_ExtensionSayings:createSayings();			
		else
			AllRound_Extension.loadError = true; --optional for !			
			print("#WARNING: ".. tostring(AllRound_Extension.metadata.title).. " CAN NOT GENERATE Box ! Check/Search: ? Mod cause with integrated HL Hud System ? ")
		end;			
	else
		AllRound_Extension.loadError = true; --optional for !		
		print("#WARNING: ".. tostring(AllRound_Extension.metadata.title).. " CAN NOT GENERATE Hud/Pda/Box ! MISSING --> HL Hud System ! Check/Search: ? Corrupt Mod with integrated HL Hud System ? ")
	end;	
end;

function AllRound_Extension:registerActionEvent()
	PlayerInputComponent.registerGlobalPlayerActionEvents = Utils.appendedFunction(
		PlayerInputComponent.registerGlobalPlayerActionEvents,
		function(self, controlling)
			if controlling ~= "VEHICLE" then
				local inputAction = InputAction.ARE_SUPERSTRENGTHONOFF;
				local callbackTarget = self;
				local callbackFunc = self.allRoundExtensionActionKeyMouse;
				local triggerUp = false;
				local triggerDown = true;
				local triggerAlways = false;
				local startActive = true;
				
				local _, eventId = g_inputBinding:registerActionEvent(inputAction, callbackTarget, callbackFunc, triggerUp, triggerDown, triggerAlways, startActive, nil, true);
				
				g_inputBinding:setActionEventTextVisibility(eventId, false);
			end
	end)
	function PlayerInputComponent:allRoundExtensionActionKeyMouse(actionName, inputValue, callbackState, isAnalog, isMouse, deviceCategory)
		if g_currentMission.hlUtils ~= nil and not g_currentMission.hlUtils.dragDrop.on then
			if actionName == "ARE_SUPERSTRENGTHONOFF" then			
				local lastState = AllRound_Extension.values.superStrength;
				AllRound_ExtensionSetGet:setPlayerSuperStrength();
				if lastState ~= AllRound_Extension.values.superStrength then
					local info = "Super strength "; --g_i18n:getText("ingameNotification_playerSuperStrengthActivated");
					--local text = g_i18n:getText("ui_missionStatusTitle").. ": ";
					local state = g_i18n:getText("ui_off");
					if AllRound_Extension.values.superStrength then state = g_i18n:getText("ui_on");end;
					g_currentMission.hlHudSystem.showInfoBox( {tostring(info).. tostring(state), 3000, g_currentMission.hlUtils.getColor("yellow", true)} );					
					--g_currentMission.hud:addSideNotification(FSBaseMission.INGAME_NOTIFICATION_OK, tostring(AllRound_Extension.metadata.title).. ": Super strength ".. tostring(state), 2500);
				end;
			end;
		end;
	end;
end;

function AllRound_Extension:delete()
	
end;

function AllRound_Extension:deleteMap()
			
end;

function AllRound_Extension:mouseEvent(posX, posY, isDown, isUp, button)
	
end;	

function AllRound_Extension:keyEvent(unicode, sym, modifier, isDown)
	
end;

function AllRound_Extension:update(dt)	
	if AllRound_Extension:getDetiServer() or AllRound_Extension.loadError then return;end;	
	if AllRound_Extension.otherMods.autoDrive then 
		function setVisible(state)
			for a=1, #AllRound_Extension.values.ad.getMod.AutoDrive.mapHotspotsBuffer do
				AllRound_Extension.values.ad.getMod.AutoDrive.mapHotspotsBuffer[a].isVisible = state;
			end;
		end;
		if AllRound_Extension.values ~= nil and AllRound_Extension.values.ad ~= nil and AllRound_Extension.values.ad.getMod.AutoDrive.getSettingState("showMarkersOnMap") then 
			if AllRound_Extension.values.ad.getMod.AutoDrive.mapHotspotsBuffer ~= nil and #AllRound_Extension.values.ad.getMod.AutoDrive.mapHotspotsBuffer > 0 then				
				if not AllRound_Extension.values.ad.showMarkersOnMinimap then
					if g_currentMission.hlUtils:getFullSize(true,true) then
						if not AllRound_Extension.values.ad.getMod.AutoDrive.mapHotspotsBuffer[1].isVisible then
							setVisible(true);
						end;
					else
						if AllRound_Extension.values.ad.getMod.AutoDrive.mapHotspotsBuffer[1].isVisible then
							setVisible(false);
						end;
					end;				
				elseif AllRound_Extension.values.ad.showMarkersOnMinimap and not AllRound_Extension.values.ad.getMod.AutoDrive.mapHotspotsBuffer[1].isVisible then
					setVisible(true);
				end;				
			end;
		end;		
	end;
	if AllRound_Extension.values ~= nil and AllRound_Extension.values.vehicleSaleSystem ~= nil and AllRound_Extension.values.vehicleSaleSystem.isOn and AllRound_Extension.values.vehicleSaleSystem.setOverlay and g_gui:getIsGuiVisible() and g_gui.currentGuiName == "ShopMenu" then AllRound_ExtensionSetGet:removeSaleMsgOrOverlay();return;end;
	if AllRound_Extension.values ~= nil and AllRound_Extension.values.superStrengthOnLoad ~= nil and AllRound_Extension.values.superStrengthOnLoad and g_localPlayer ~= nil and g_localPlayer.hands ~= nil and g_localPlayer.hands.consoleCommandToggleSuperStrength ~= nil then AllRound_Extension.values.superStrengthOnLoad = false;AllRound_ExtensionSetGet:setPlayerSuperStrength(true);end;
	if not g_currentMission.missionDynamicInfo.isMultiplayer and AllRound_Extension.values ~= nil and AllRound_Extension.values.superStrength ~= nil and AllRound_Extension.values.superStrength then
		if g_localPlayer ~= nil and g_localPlayer.hands ~= nil and g_localPlayer.hands.spec_hands ~= nil then
			if g_currentMission.hlUtils.isMouseCursor then g_localPlayer.hands.spec_hands.currentMaximumMass = HandToolHands.MAXIMUM_PICKUP_MASS;else g_localPlayer.hands.spec_hands.currentMaximumMass = HandToolHands.SUPER_STRENGTH_PICKUP_MASS;end; --behind cursor active and strong farmer
		end;
	end;
	if AllRound_Extension.values ~= nil and AllRound_Extension.values.guiMenu ~= nil and AllRound_Extension.values.mouseCursorMarker.isOn then AllRound_ExtensionSetGet:setMouseCursorMarker();end;
	--if g_currentMission.hlHudSystem:getIsMpOff() and not AllRound_Extension.values.handTool.switch then AllRound_Extension.values.handTool.switch = true;end;
end;

function AllRound_Extension:draw()
	if not AllRound_Extension:getDetiServer() and not AllRound_Extension.loadError then g_currentMission.hlHudSystem.clickAreas["AllRound_Extension_OtherAreas"] = {};end; --reset click areas
	--if not AllRound_Extension:getDetiServer() and not AllRound_Extension.loadError then AllRound_Extension_DrawIcon:setSaleInfoOverlay();end;
	if AllRound_Extension:getDetiServer() or g_currentMission.hlUtils:getFullSize(true,true) then return;end; --or g_currentMission.hlUtils:getIngameMap()
	--respect settings for other mods (not every mod) that's why
	setTextAlignment(0);
	setTextLineBounds(0, 0);
	setTextWrapWidth(0);
	setTextColor(1, 1, 1, 1);
	setTextBold(false);
	--respect settings for other mods	
	
	if #AllRound_Extension.testString > 0 then
		setTextBold(true);		
		for a=1, #AllRound_Extension.testString do
			local posY = 0.25-(a/100);
			renderText(0.5, posY, 0.010, "-S ".. tostring(a).. "- ".. tostring(AllRound_Extension.testString[a]));
		end;
	end;
	if not AllRound_Extension.loadError then 
		local newUiScale = false;
		if AllRound_Extension.values ~= nil and AllRound_Extension.values.guiMenu ~= nil then
			local guiBox = AllRound_Extension.values.guiMenu;			
			if guiBox ~= nil and guiBox.screen:isNewUiScale() then newUiScale = true;guiBox.screen:resetUiScale();end;
			if g_currentMission.hlUtils.isMouseCursor and AllRound_Extension.values.mouseCursorMarker.isOn then AllRound_ExtensionSetGet:renderMouseCursorMarker(guiBox);end;
		end;
		AllRound_ExtensionSetGet:setMiniMapState(newUiScale);AllRound_ExtensionSetGet:setTemporaryData(newUiScale);AllRound_Extension_DrawIcon:setSaleInfoOverlay(newUiScale);
	end; --AllRound_Extension_DrawIcon:setOpen();
	
	--respect settings for other mods
	setTextAlignment(0);
	setTextLineBounds(0, 0);
	setTextWrapWidth(0);
	setTextColor(1, 1, 1, 1);
	setTextBold(false);
	--respect settings for other mods
end;
addModEventListener(AllRound_Extension);

function AllRound_Extension:getDetiServer()	
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer ~= nil;	
end;

function AllRound_Extension:searchOtherMods()
	AllRound_Extension.otherMods.autoDrive = g_modIsLoaded["FS25_AutoDrive"] and _G["FS25_AutoDrive"] ~= nil;
	AllRound_Extension.otherMods.extendedGameInfoDisplay = g_modIsLoaded["FS25_ExtendedGameInfoDisplay"] and _G["FS25_ExtendedGameInfoDisplay"] ~= nil and FS25_ExtendedGameInfoDisplay.ExtendedGameInfoDisplay.STRECH_GAME_INFO_DISPLAY ~= nil;
	AllRound_Extension.otherMods.realisticWeather = g_modIsLoaded["FS25_RealisticWeather"] and _G["FS25_RealisticWeather"] ~= nil;	
end;

function AllRound_Extension:loadSource(int)
	if int == 1 then		
		source(AllRound_Extension.modDir.."scripte_are/AllRound_ExtensionSetGet.lua");
		source(AllRound_Extension.modDir.."scripte_are/AllRound_ExtensionSayings.lua");		
	elseif int == 2 then		
		source(AllRound_Extension.modDir.."scripte_are/AllRound_ExtensionGuiBoxSetGet.lua");		
		source(AllRound_Extension.modDir.."scripte_are/draw/AllRound_Extension_DrawIcon.lua");
		source(AllRound_Extension.modDir.."scripte_are/mouseKeyEvents/AllRound_Extension_MouseKeyEventsGuiBox.lua");
		source(AllRound_Extension.modDir.."scripte_are/xml/AllRound_Extension_XmlGuiBox.lua");
		source(AllRound_Extension.modDir.."scripte_are/mouseKeyEvents/AllRound_Extension_MouseKeyEvents.lua");		
	end;
end;

function generateFolders()
	createFolder(getUserProfileAppPath().. "modSettings/");
	createFolder(getUserProfileAppPath().. "modSettings/HL/");
	createFolder(getUserProfileAppPath().. "modSettings/HL/FS25_AllRoundExtension/");
	createFolder(getUserProfileAppPath().. "modSettings/HL/FS25_AllRoundExtension/languages/");			
end;

function AllRound_Extension:replaceSystem()
	HandToolChainsaw.MAXIMUM_CUT_DISTANCE = 4;
	PlayerStateWalk.MAXIMUM_WALK_SPEED = 6;
	VehicleSaleSystem.MIN_MULTIPLAYER_ITEM_DURATION = 10;
	VehicleSaleSystem.MAX_MULTIPLAYER_ITEM_DURATION = 25;
	VehicleSaleSystem.MIN_GENERATED_ITEM_DURATION = 10;
	VehicleSaleSystem.MAX_GENERATED_ITEM_DURATION = 25;
	VehicleSaleSystem.MAX_GENERATED_ITEMS = 10;
	VehicleSaleSystem.GENERATED_HOURLY_CHANCE = 3 / 4.18; -- change ~70%
end;

function AllRound_Extension:replaceHandTool()			
	if AllRound_Extension.values == nil then AllRound_Extension.values = {handToolSpeed={2,1,2,1,1.1}};end;
	oldHandToolSystem = HandToolSystem.addHandTool;
	HandToolSystem.addHandTool = function (self, handTool)
		local isOkay, result = pcall(oldHandToolSystem, self, handTool);
		if isOkay and result and AllRound_Extension.values ~= nil and AllRound_Extension.values.handToolSpeed[1] > 1 then
			if handTool.walkMultiplier ~= nil and handTool.walkMultiplier < AllRound_Extension.values.handToolSpeed[4] then handTool.walkMultiplier = AllRound_Extension.values.handToolSpeed[4];end;
			if handTool.runMultiplier ~= nil and handTool.runMultiplier < AllRound_Extension.values.handToolSpeed[5] then handTool.runMultiplier = AllRound_Extension.values.handToolSpeed[5];end;			
		end;		
		return result;
	end;	
end;